/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.mockito.Captor;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.api.mockito.internal.configuration.PowerMockitoInjectingAnnotationEngine;
import org.powermock.core.classloader.annotations.Mock;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    public void beforeTestMethod(Object testInstance, Method method, Object[] arguments) throws Exception {
        this.standardInject(testInstance);
        this.injectSpiesAndInjectToSetters(testInstance);
        this.injectCaptor(testInstance);
    }

    private void injectSpiesAndInjectToSetters(Object testInstance) {
        new PowerMockitoInjectingAnnotationEngine().process(testInstance.getClass(), testInstance);
    }

    private void injectCaptor(Object testInstance) throws Exception {
        Set fieldsAnnotatedWithCaptor = Whitebox.getFieldsAnnotatedWith((Object)testInstance, Captor.class, (Class[])new Class[0]);
        for (Field field : fieldsAnnotatedWithCaptor) {
            Object captor = Whitebox.invokeMethod((Object)new DefaultAnnotationEngine(), (String)"processAnnotationOn", (Object[])new Object[]{field.getAnnotation(Captor.class), field});
            field.set(testInstance, captor);
        }
    }

    private void standardInject(Object testInstance) throws IllegalAccessException {
        Set fields = Whitebox.getFieldsAnnotatedWith((Object)testInstance, (Class[])this.getMockAnnotations());
        for (Field field : fields) {
            Mock annotation;
            String[] value;
            if (field.get(testInstance) != null) continue;
            Class<?> type = field.getType();
            if (field.isAnnotationPresent(Mock.class) && ((value = (annotation = field.getAnnotation(Mock.class)).value()).length != 1 || !"".equals(value[0]))) {
                System.err.println("PowerMockito deprecation: Use PowerMockito.spy(..) for partial mocking instead. A standard mock will be created instead.");
            }
            field.set(testInstance, PowerMockito.mock(type));
        }
    }

    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{org.mockito.Mock.class, MockitoAnnotations.Mock.class, Mock.class};
    }
}

