/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal;

import org.mockito.Mockito;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.internal.expectation.PowerMockitoStubberImpl;
import org.powermock.api.mockito.internal.verification.StaticMockAwareVerificationMode;
import org.powermock.reflect.Whitebox;

public class PowerMockitoCore {
    public PowerMockitoStubber doAnswer(Answer answer) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.getMockingProgress().stubbingStarted();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        this.getMockingProgress().resetOngoingStubbing();
        return (PowerMockitoStubber)new PowerMockitoStubberImpl().doAnswer(answer);
    }

    private MockingProgress getMockingProgress() {
        return (MockingProgress)Whitebox.getInternalState(Mockito.class, MockingProgress.class);
    }

    public MockAwareVerificationMode wrapInMockitoSpecificVerificationMode(Object mock, VerificationMode mode) {
        return new MockAwareVerificationMode(mock, mode);
    }

    public MockAwareVerificationMode wrapInStaticVerificationMode(VerificationMode mode) {
        return new StaticMockAwareVerificationMode(mode);
    }
}

