/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoAssertionError;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.invocation.MockitoNewInvocationControl;
import org.powermock.api.mockito.verification.ConstructorArgumentsVerification;
import org.powermock.core.spi.NewInvocationControl;

public class DefaultConstructorArgumentsVerfication<T>
implements ConstructorArgumentsVerification {
    private final MockitoNewInvocationControl<T> invocationControl;
    private final Class<?> type;

    public DefaultConstructorArgumentsVerfication(NewInvocationControl<T> invocationControl, Class<?> type) {
        this.type = type;
        this.invocationControl = (MockitoNewInvocationControl)invocationControl;
    }

    @Override
    public void withArguments(Object argument, Object ... arguments) throws Exception {
        Object[] realArguments;
        if (argument == null && arguments.length == 0) {
            realArguments = null;
        } else {
            realArguments = new Object[arguments.length + 1];
            realArguments[0] = argument;
            System.arraycopy(arguments, 0, realArguments, 1, arguments.length);
        }
        this.invokeSubstitute(realArguments);
    }

    private void invokeSubstitute(Object ... arguments) throws Exception {
        try {
            this.invocationControl.getSubstitute().performSubstitutionLogic(arguments);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure((AssertionError)((Object)e), this.type);
        }
    }

    @Override
    public void withNoArguments() throws Exception {
        this.invokeSubstitute(new Object[0]);
    }
}

