/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;
import org.powermock.api.mockito.internal.invocation.MockitoMethodInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.AbstractMockCreator;
import org.powermock.api.mockito.internal.mockcreation.MockitoStateCleaner;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;

public class DefaultMockCreator
extends AbstractMockCreator {
    private static final DefaultMockCreator MOCK_CREATOR = new DefaultMockCreator();

    public static <T> T mock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        return MOCK_CREATOR.createMock(type, isStatic, isSpy, delegator, mockSettings, methods);
    }

    public <T> T createMock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        if (type == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        this.validateType(type, isStatic, isSpy);
        String mockName = this.toInstanceName(type, mockSettings);
        MockRepository.addAfterMethodRunner((Runnable)new MockitoStateCleanerRunnable());
        Class typeToMock = DefaultMockCreator.isFinalJavaSystemClass(type) ? new ClassReplicaCreator().createClassReplica(type) : type;
        MockData<T> mockData = DefaultMockCreator.createMethodInvocationControl(mockName, typeToMock, methods, isSpy, delegator, mockSettings);
        Object mock = mockData.getMock();
        if (DefaultMockCreator.isFinalJavaSystemClass(type) && !isStatic) {
            mock = Whitebox.newInstance((Class)type);
            DefaultFieldValueGenerator.fillWithDefaultValues(mock);
        }
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl((Class)type, (MethodInvocationControl)mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl(mock, (MethodInvocationControl)mockData.getMethodInvocationControl());
        }
        if (isSpy) {
            new LenientCopyTool().copyToMock(delegator, mock);
        }
        return mock;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> type) {
        return type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
    }

    private static <T> MockData<T> createMethodInvocationControl(String mockName, Class<T> type, Method[] methods, boolean isSpy, Object delegator, MockSettings mockSettings) {
        MockMaker mockMaker = DefaultMockCreator.getMockMaker();
        MockSettingsImpl settings = mockSettings == null ? (MockSettingsImpl)Mockito.withSettings() : (MockSettingsImpl)mockSettings;
        if (isSpy) {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        settings.setMockName((MockName)new MockNameImpl(mockName));
        settings.setTypeToMock(type);
        InternalMockHandler mockHandler = MockHandlerFactory.createMockHandler((MockCreationSettings)settings);
        Object mock = mockMaker.createMock((MockCreationSettings)settings, (MockHandler)mockHandler);
        ClassLoader classLoader = mock.getClass().getClassLoader();
        if (classLoader instanceof MockClassLoader) {
            MockClassLoader mcl = (MockClassLoader)classLoader;
            mcl.cache(mock.getClass());
        }
        MockitoMethodInvocationControl invocationControl = new MockitoMethodInvocationControl((MockHandler)mockHandler, isSpy && delegator == null ? new Object() : delegator, mock, methods);
        return new MockData<Object>(invocationControl, mock);
    }

    private static MockMaker getMockMaker() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DefaultMockCreator.class.getClassLoader());
        try {
            MockMaker mockMaker = Plugins.getMockMaker();
            return mockMaker;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private String toInstanceName(Class<?> clazz, MockSettings mockSettings) {
        String settingName;
        if (mockSettings instanceof MockSettingsImpl && (settingName = ((MockSettingsImpl)mockSettings).getName()) != null) {
            return settingName;
        }
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            return clazz.getName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    private static class MockitoStateCleanerRunnable
    implements Runnable {
        private MockitoStateCleanerRunnable() {
        }

        @Override
        public void run() {
            MockitoStateCleaner cleaner = new MockitoStateCleaner();
            cleaner.clearConfiguration();
            cleaner.clearMockProgress();
        }
    }

    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

