/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.powermock.api.mockito.internal.mockcreation.AbstractMockCreator;
import org.powermock.api.mockito.invocation.MockitoMethodInvocationControl;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;
import org.powermock.utils.Asserts;

public class DefaultMockCreator
extends AbstractMockCreator {
    private static final DefaultMockCreator MOCK_CREATOR = new DefaultMockCreator();

    public static <T> T mock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        return MOCK_CREATOR.createMock(type, isStatic, isSpy, delegator, mockSettings, methods);
    }

    @Override
    public <T> T createMock(Class<T> type, boolean isStatic, boolean isSpy, Object delegatorCandidate, MockSettings mockSettings, Method ... methods) {
        Asserts.assertNotNull(type, (String)"The class to mock cannot be null");
        this.validateType(type, isStatic, isSpy);
        this.registerAfterMethodRunner();
        return this.doCreateMock(type, isStatic, isSpy, delegatorCandidate, mockSettings, methods);
    }

    private <T> T doCreateMock(Class<T> type, boolean isStatic, boolean isSpy, Object delegatorCandidate, MockSettings mockSettings, Method[] methods) {
        Class<T> typeToMock = this.getMockType(type);
        Object delegator = isSpy && delegatorCandidate == null ? new Object() : delegatorCandidate;
        MockData<T> mockData = this.createMethodInvocationControl(typeToMock, methods, delegator, mockSettings);
        Object mock = ((MockData)mockData).getMock();
        if (DefaultMockCreator.isFinalJavaSystemClass(type) && !isStatic) {
            mock = Whitebox.newInstance(type);
            DefaultFieldValueGenerator.fillWithDefaultValues((Object)mock);
        }
        this.putMethodInvocationControlToRepository(type, isStatic, mockData, mock);
        return (T)mock;
    }

    private void registerAfterMethodRunner() {
        MockRepository.addAfterMethodRunner((Runnable)new Runnable(){

            @Override
            public void run() {
                Mockito.reset((Object[])new Object[0]);
            }
        });
    }

    private <T> void putMethodInvocationControlToRepository(Class<T> type, boolean isStatic, MockData<T> mockData, T mock) {
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl(type, (MethodInvocationControl)((MockData)mockData).getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl(mock, (MethodInvocationControl)((MockData)mockData).getMethodInvocationControl());
        }
    }

    private <T> Class<T> getMockType(Class<T> type) {
        Class typeToMock = DefaultMockCreator.isFinalJavaSystemClass(type) ? new ClassReplicaCreator().createClassReplica(type) : type;
        return typeToMock;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> type) {
        return type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
    }

    private <T> MockData<T> createMethodInvocationControl(Class<T> type, Method[] methods, Object delegator, MockSettings mockSettings) {
        Object mock = Mockito.mock(type, (MockSettings)(mockSettings != null ? mockSettings : Mockito.withSettings()));
        this.cacheMockClass(mock.getClass());
        return new MockData(new MockitoMethodInvocationControl<Object>(delegator, mock, methods), mock);
    }

    private void cacheMockClass(Class<?> mockClass) {
        ClassLoader classLoader = mockClass.getClassLoader();
        if (classLoader instanceof MockClassLoader) {
            MockClassLoader mcl = (MockClassLoader)classLoader;
            mcl.cache(mockClass);
        }
    }

    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        private MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        private MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        private T getMock() {
            return this.mock;
        }
    }
}

