/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.invocation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.stubbing.MockitoRealMethodInvocation;
import org.powermock.api.mockito.invocation.MockHandlerAdaptor;
import org.powermock.core.MockGateway;
import org.powermock.core.spi.MethodInvocationControl;

public class MockitoMethodInvocationControl<T>
implements MethodInvocationControl {
    private final Set<Method> mockedMethods;
    private final Object delegator;
    private final MockHandlerAdaptor<T> mockHandlerAdaptor;

    public MockitoMethodInvocationControl(Object delegator, T mockInstance, Method ... methodsToMock) {
        this.mockHandlerAdaptor = new MockHandlerAdaptor<T>(mockInstance);
        this.mockedMethods = this.toSet(methodsToMock);
        this.delegator = delegator;
    }

    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods.contains(method);
    }

    public Object invoke(Object mock, Method method, Object[] arguments) throws Throwable {
        Object returnValue;
        if (this.isCanBeHandledByMockito(method) && this.hasBeenCaughtByMockitoProxy()) {
            returnValue = MockGateway.PROCEED;
        } else {
            returnValue = this.mockHandlerAdaptor.performIntercept(mock, method, arguments);
            if (returnValue == null) {
                return MockGateway.SUPPRESS;
            }
        }
        return returnValue;
    }

    private boolean isCanBeHandledByMockito(Method method) {
        int modifiers = method.getModifiers();
        return this.hasDelegator() && !Modifier.isPrivate(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers);
    }

    private boolean hasBeenCaughtByMockitoProxy() {
        return MockitoRealMethodInvocation.isHandledByMockito();
    }

    public Object replay(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as replay exists in Mockito.");
    }

    public Object reset(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as reset exists in Mockito.");
    }

    public void verifyNoMoreInteractions() {
        try {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.getMockHandlerAdaptor().getMock()});
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)e));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error", e);
        }
    }

    private Set<Method> toSet(Method ... methods) {
        return methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
    }

    private boolean hasDelegator() {
        return this.delegator != null;
    }

    public MockHandlerAdaptor<T> getMockHandlerAdaptor() {
        return this.mockHandlerAdaptor;
    }
}

