/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.agent;

import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.core.agent.JavaAgentFrameworkRegister;
import org.powermock.reflect.Whitebox;

public class JavaAgentFrameworkRegisterImpl
implements JavaAgentFrameworkRegister {
    public static final String MOCK_CREATOR_IMPLEMENTATION_CLASS = "org.powermock.api.mockito.internal.mockcreation.DefaultMockCreator";
    private MockCreator mockCreator;

    public void set(JavaAgentClassRegister javaAgentClassRegister) {
        this.setToPowerMockito(javaAgentClassRegister);
    }

    private void setToPowerMockito(JavaAgentClassRegister javaAgentClassRegister) {
        this.mockCreator = this.getPowerMockCoreForCurrentClassLoader();
        Whitebox.setInternalState((Object)this.mockCreator, (String)"agentClassRegister", (Object)javaAgentClassRegister);
    }

    private MockCreator getPowerMockCoreForCurrentClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return (MockCreator)Whitebox.getInternalState(classLoader.loadClass(MOCK_CREATOR_IMPLEMENTATION_CLASS), (String)"MOCK_CREATOR");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        if (this.mockCreator == null) {
            throw new IllegalStateException("Cannot clear JavaAgentClassRegister. Set method has not been called.");
        }
        Whitebox.setInternalState((Object)this.mockCreator, (String)"agentClassRegister", null);
    }
}

