/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.invocation;

import java.lang.reflect.Method;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.api.mockito.invocation.InvocationFactory;
import org.powermock.core.MockRepository;

public class MockHandlerAdaptor<T> {
    private final T mock;
    private final InvocationFactory invocationFactory;
    private final MockingDetails mockingDetails;

    MockHandlerAdaptor(T mock) {
        this.mock = mock;
        this.invocationFactory = new InvocationFactory();
        this.mockingDetails = Mockito.mockingDetails(mock);
    }

    public Object getMock() {
        return this.mock;
    }

    public MockCreationSettings<?> getMockSettings() {
        return this.mockingDetails.getMockCreationSettings();
    }

    private MockHandler getMockHandler() {
        return this.mockingDetails.getMockHandler();
    }

    Object performIntercept(Object mock, Method method, Object[] arguments) throws Throwable {
        Invocation invocation = this.createInvocation(mock, method, arguments);
        try {
            return this.getMockHandler().handle(invocation);
        }
        catch (NotAMockException e) {
            if (invocation.getMock().getClass().getName().startsWith("java.") && MockRepository.getInstanceMethodInvocationControl((Object)invocation.getMock()) != null) {
                return invocation.callRealMethod();
            }
            throw e;
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForMethodInvocation((AssertionError)((Object)e));
            throw e;
        }
    }

    private Invocation createInvocation(Object mock, Method method, Object[] arguments) {
        return this.invocationFactory.createInvocation(mock, method, this.getMockHandler().getMockSettings(), arguments);
    }
}

