/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.powermock.core.WildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassTransformer {
    protected static final List<String> ALWAYS_IGNORED = new LinkedList<String>();
    protected final List<String> USER_IGNORED = Collections.synchronizedList(new LinkedList());

    public synchronized void setPackagesToIgnore(List<String> packagesToIgnore) {
        this.USER_IGNORED.clear();
        this.USER_IGNORED.addAll(packagesToIgnore);
    }

    public void resetPackagesToIgnore() {
        this.USER_IGNORED.clear();
    }

    protected boolean shouldIgnore(String className) {
        return WildcardMatcher.matchesAny(this.merge(ALWAYS_IGNORED, this.USER_IGNORED), (String)this.replaceSlashWithDots(className));
    }

    private List<String> merge(List<String> alwaysIgnored, List<String> userIgnored) {
        LinkedList<String> list = new LinkedList<String>(alwaysIgnored);
        list.addAll(userIgnored);
        return Collections.unmodifiableList(list);
    }

    String replaceSlashWithDots(String className) {
        return className.replaceAll("/", ".");
    }

    static {
        ALWAYS_IGNORED.add("org.powermock.*");
        ALWAYS_IGNORED.add("org.junit.*");
        ALWAYS_IGNORED.add("org.mockito.*");
        ALWAYS_IGNORED.add("javassist.*");
        ALWAYS_IGNORED.add("org.objenesis.*");
        ALWAYS_IGNORED.add("junit.*");
        ALWAYS_IGNORED.add("org.hamcrest.*");
        ALWAYS_IGNORED.add("sun.*");
        ALWAYS_IGNORED.add("$Proxy*");
        ALWAYS_IGNORED.add("*CGLIB$$*");
        ALWAYS_IGNORED.add("*$$PowerMock*");
    }
}

