/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sun.tools.attach.HotSpotVirtualMachine;

public class SolarisVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir = "/tmp";
    private int fd = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolarisVirtualMachine(AttachProvider provider, String vmid) throws AttachNotSupportedException, IOException {
        super(provider, vmid);
        int pid;
        try {
            pid = Integer.parseInt(vmid);
        }
        catch (NumberFormatException x) {
            throw new AttachNotSupportedException("invalid process identifier");
        }
        try {
            this.fd = this.openDoor(pid);
        }
        catch (FileNotFoundException fnf1) {
            File f = this.createAttachFile(pid);
            try {
                SolarisVirtualMachine.sigquit(pid);
                int i = 0;
                long delay = 200L;
                int retries = (int)(this.attachTimeout() / delay);
                do {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException x) {
                        // empty catch block
                    }
                    try {
                        this.fd = this.openDoor(pid);
                    }
                    catch (FileNotFoundException fnf2) {
                        // empty catch block
                    }
                } while (++i <= retries && this.fd == -1);
                if (this.fd == -1) {
                    throw new AttachNotSupportedException("Unable to open door: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                f.delete();
            }
        }
        assert (this.fd >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd != -1) {
                SolarisVirtualMachine.close(this.fd);
                this.fd = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String cmd, Object ... args) throws AgentLoadException, IOException {
        int completionStatus;
        int door;
        assert (args.length <= 3);
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd == -1) {
                throw new IOException("Detached from target VM");
            }
            door = this.fd;
        }
        int s = SolarisVirtualMachine.enqueue(door, cmd, args);
        assert (s >= 0);
        SocketInputStream sis = new SocketInputStream(s);
        try {
            completionStatus = this.readInt(sis);
        }
        catch (IOException ioe) {
            sis.close();
            throw ioe;
        }
        if (completionStatus != 0) {
            sis.close();
            if (cmd.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            throw new IOException("Command failed in target VM");
        }
        return sis;
    }

    private int openDoor(int pid) throws IOException {
        String path = "/tmp/.java_pid" + pid;
        this.fd = SolarisVirtualMachine.open(path);
        try {
            SolarisVirtualMachine.checkPermissions(path);
        }
        catch (IOException ioe) {
            SolarisVirtualMachine.close(this.fd);
            throw ioe;
        }
        return this.fd;
    }

    private File createAttachFile(int pid) throws IOException {
        String fn = ".attach_pid" + pid;
        String path = "/proc/" + pid + "/cwd/" + fn;
        File f = new File(path);
        try {
            f.createNewFile();
        }
        catch (IOException x) {
            f = new File(tmpdir, fn);
            f.createNewFile();
        }
        return f;
    }

    static native int open(String var0) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native void sigquit(int var0) throws IOException;

    static native int enqueue(int var0, String var1, Object ... var2) throws IOException;

    static {
        System.loadLibrary("attach");
    }

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int s) {
            this.s = s;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            if (n == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] bs, int off, int len) throws IOException {
            if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            return SolarisVirtualMachine.read(this.s, bs, off, len);
        }

        @Override
        public void close() throws IOException {
            SolarisVirtualMachine.close(this.s);
        }
    }
}

