/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.legacy.internal.impl;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class PowerMockJUnit4LegacyFilter
extends Filter {
    private final String[] methodNamesToRun;

    public PowerMockJUnit4LegacyFilter(String[] methodNamesToRun) {
        this.methodNamesToRun = methodNamesToRun;
    }

    public String describe() {
        return this.methodNamesToRun.length + " tests.";
    }

    public boolean shouldRun(Description description) {
        boolean shouldRun = false;
        for (String testMethodName : this.methodNamesToRun) {
            if (!testMethodName.equals(this.extractMethodName(description))) continue;
            shouldRun = true;
            break;
        }
        return shouldRun;
    }

    private String extractMethodName(Description description) {
        String displayName = description.getDisplayName();
        int indexOfParenthesis = displayName.indexOf(40);
        if (indexOfParenthesis == -1) {
            throw new RuntimeException("Internal error: Failed to find the test method name.");
        }
        return displayName.substring(0, indexOfParenthesis);
    }
}

