/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng.internal;

import java.lang.reflect.Constructor;
import javassist.util.proxy.ProxyFactory;
import org.powermock.modules.testng.PowerMockTestCase;
import org.powermock.modules.testng.internal.ClassLoaderFactory;
import org.powermock.modules.testng.internal.PowerMockTestNGMethodHandler;
import org.powermock.modules.testng.internal.TestNGMethodFilter;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

class TestClassInstanceFactory {
    private final Constructor constructor;
    private final Class<?> testClass;
    private final Object[] params;
    private final ClassLoader mockLoader;

    TestClassInstanceFactory(Constructor constructor, ClassLoaderFactory classLoaderFactory, Object ... params) {
        this.constructor = constructor;
        this.params = params;
        this.testClass = constructor.getDeclaringClass();
        this.mockLoader = classLoaderFactory.createClassLoader(this.testClass);
    }

    Object create() {
        try {
            this.initializeMockPolicy();
            Class<?> testClassLoadedByMockedClassLoader = this.createTestClass(this.testClass);
            Constructor<?> con = testClassLoadedByMockedClassLoader.getConstructor(this.constructor.getParameterTypes());
            Object testInstance = con.newInstance(this.params);
            if (!this.extendsPowerMockTestCase(this.testClass)) {
                this.setInvocationHandler(testInstance);
            }
            return testInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot create a new instance of test class %s", this.testClass), e);
        }
    }

    private void initializeMockPolicy() {
        new MockPolicyInitializerImpl(this.testClass).initialize(this.mockLoader);
    }

    private Class<?> createTestClass(Class<?> actualTestClass) throws Exception {
        Class<?> testClassLoadedByMockedClassLoader = Class.forName(actualTestClass.getName(), false, this.mockLoader);
        if (this.extendsPowerMockTestCase(actualTestClass)) {
            return testClassLoadedByMockedClassLoader;
        }
        return this.createProxyTestClass(testClassLoadedByMockedClassLoader);
    }

    private Class<?> createProxyTestClass(Class<?> testClassLoadedByMockedClassLoader) throws Exception {
        Class<?> proxyFactoryClass = Class.forName(ProxyFactory.class.getName(), false, this.mockLoader);
        Class<?> testNGMethodFilterByMockedClassLoader = Class.forName(TestNGMethodFilter.class.getName(), false, this.mockLoader);
        Object f = proxyFactoryClass.newInstance();
        Object filter = testNGMethodFilterByMockedClassLoader.newInstance();
        Whitebox.invokeMethod(f, (String)"setFilter", (Object[])new Object[]{filter});
        Whitebox.invokeMethod(f, (String)"setSuperclass", (Object[])new Object[]{testClassLoadedByMockedClassLoader});
        return (Class)Whitebox.invokeMethod(f, (String)"createClass", (Object[])new Object[0]);
    }

    private void setInvocationHandler(Object testInstance) throws Exception {
        Class<?> powerMockTestNGMethodHandlerClass = Class.forName(PowerMockTestNGMethodHandler.class.getName(), false, this.mockLoader);
        Object powerMockTestNGMethodHandlerInstance = powerMockTestNGMethodHandlerClass.getConstructor(Class.class).newInstance(testInstance.getClass());
        Whitebox.invokeMethod((Object)testInstance, (String)"setHandler", (Object[])new Object[]{powerMockTestNGMethodHandlerInstance});
    }

    private boolean extendsPowerMockTestCase(Class<?> actualTestClass) {
        return PowerMockTestCase.class.isAssignableFrom(actualTestClass);
    }
}

