/*
 * Decompiled with CFR 0.152.
 */
package samples.expectnew;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import samples.Service;
import samples.expectnew.CreationException;
import samples.expectnew.ExpectNewServiceUser;
import samples.expectnew.ITarget;
import samples.expectnew.SimpleVarArgsConstructorDemo;
import samples.expectnew.Target;
import samples.expectnew.VarArgsConstructorDemo;
import samples.newmocking.MyClass;

public class ExpectNewDemo {
    private int dummyField;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dummyField;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpectNewDemo other = (ExpectNewDemo)obj;
        return this.dummyField == other.dummyField;
    }

    public String getMessage() {
        MyClass myClass = new MyClass();
        return myClass.getMessage();
    }

    public String getMessageWithArgument() {
        MyClass myClass = new MyClass();
        return myClass.getMessage("test");
    }

    public void invokeVoidMethod() {
        MyClass myClass = new MyClass();
        myClass.voidMethod();
    }

    public void throwExceptionWhenInvoction() {
        new MyClass();
    }

    public void throwExceptionAndWrapInRunTimeWhenInvoction() {
        try {
            new MyClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String multipleNew() {
        MyClass myClass1 = new MyClass();
        MyClass myClass2 = new MyClass();
        String message1 = myClass1.getMessage();
        String message2 = myClass2.getMessage();
        return message1 + message2;
    }

    public void simpleMultipleNew() {
        new MyClass();
        new MyClass();
        new MyClass();
    }

    private void simpleMultipleNewPrivate() {
        new MyClass();
        new MyClass();
        new MyClass();
    }

    public void simpleSingleNew() {
        new MyClass();
    }

    public Date makeDate() {
        return new Date();
    }

    public boolean fileExists(String name) {
        return new File(name).exists();
    }

    public InputStream alternativePath() {
        try {
            return new DataInputStream(null);
        }
        catch (RuntimeException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public String newWithArguments(Service service, int times) {
        return new ExpectNewServiceUser(service, times).useService();
    }

    public String newWithWrongArguments(Service service, int times) {
        return new ExpectNewServiceUser(service, times * 2).useService();
    }

    public String[] newVarArgs(String ... strings) {
        return new VarArgsConstructorDemo(strings).getAllMessages();
    }

    public Service[] newVarArgs(Service ... services) {
        return new VarArgsConstructorDemo(services).getAllServices();
    }

    public int[] newVarArgs(float myFloat, int ... ints) {
        return new VarArgsConstructorDemo(myFloat, ints).getInts();
    }

    public byte[][] newVarArgs(byte[] ... bytes) {
        return new VarArgsConstructorDemo(bytes).getByteArrays();
    }

    public byte[][] newVarArgsWithMatchers() {
        return new VarArgsConstructorDemo({42}, {17}).getByteArrays();
    }

    public void fileWriter(String name, String msg) throws IOException {
        new FileWriter(name).write(msg);
    }

    public void fileWriterPrint(String name, String msg) throws IOException {
        new PrintWriter(new FileWriter(name)).write(msg);
    }

    public byte[][] newSimpleVarArgs(byte[] ... bytes) {
        return new SimpleVarArgsConstructorDemo(bytes).getByteArrays();
    }

    public Target createTarget(ITarget target) {
        Target domainTarget;
        try {
            domainTarget = new Target(this.getTargetName(target), target.getId());
        }
        catch (CreationException e) {
            domainTarget = new Target("Unknown", -1);
        }
        return domainTarget;
    }

    private String getTargetName(ITarget target) {
        return target.getName();
    }
}

