/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.DbImpl;
import org.iq80.leveldb.util.FileUtils;

public class Iq80DBFactory
implements DBFactory {
    public static final boolean IS_64_BIT = Iq80DBFactory.is64bit();
    public static final boolean USE_MMAP = Boolean.parseBoolean(System.getProperty("leveldb.mmap", Boolean.toString(IS_64_BIT)));
    public static final String VERSION = Iq80DBFactory.getVersion();
    public static final Iq80DBFactory factory = new Iq80DBFactory();

    private static boolean is64bit() {
        boolean is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
        return is64bit;
    }

    private static String getVersion() {
        String version = "unknown";
        InputStream is = Iq80DBFactory.class.getResourceAsStream("version.txt");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            version = reader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    public static byte[] bytes(String value) {
        if (value == null) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static String asString(byte[] value) {
        if (value == null) {
            return null;
        }
        return new String(value, StandardCharsets.UTF_8);
    }

    public DB open(File path, Options options) throws IOException {
        return new DbImpl(options, path);
    }

    public void destroy(File path, Options options) throws IOException {
        FileUtils.deleteRecursively(path);
    }

    public void repair(File path, Options options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("iq80 leveldb version %s", VERSION);
    }
}

