/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.iq80.leveldb.table.FileChannelTable;
import org.iq80.leveldb.table.MMapTable;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Finalizer;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.Slice;

public class TableCache {
    private final LoadingCache<Long, TableAndFile> cache;
    private final Finalizer<Table> finalizer = new Finalizer(1);

    public TableCache(File databaseDir, int tableCacheSize, UserComparator userComparator, boolean verifyChecksums) {
        Preconditions.checkNotNull((Object)databaseDir, (Object)"databaseName is null");
        this.cache = CacheBuilder.newBuilder().maximumSize((long)tableCacheSize).removalListener(notification -> {
            Table table = ((TableAndFile)notification.getValue()).getTable();
            this.finalizer.addCleanup(table, table.closer());
        }).build(CacheLoader.from(fileNumber -> {
            try {
                return new TableAndFile(databaseDir, (long)fileNumber, userComparator, verifyChecksums);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public InternalTableIterator newIterator(FileMetaData file) {
        return this.newIterator(file.getNumber());
    }

    public InternalTableIterator newIterator(long number) {
        return new InternalTableIterator(this.getTable(number).iterator());
    }

    public long getApproximateOffsetOf(FileMetaData file, Slice key) {
        return this.getTable(file.getNumber()).getApproximateOffsetOf(key);
    }

    private Table getTable(long number) {
        Table table;
        try {
            table = ((TableAndFile)this.cache.get((Object)number)).getTable();
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new RuntimeException("Could not open table " + number, cause);
        }
        return table;
    }

    public void close() {
        this.cache.invalidateAll();
        this.finalizer.destroy();
    }

    public void evict(long number) {
        this.cache.invalidate((Object)number);
    }

    public void clearBlockCaches() {
        for (Map.Entry longTableAndFileEntry : this.cache.asMap().entrySet()) {
            ((TableAndFile)longTableAndFileEntry.getValue()).getTable().clearBlockCache();
        }
    }

    private static final class TableAndFile {
        private final Table table;

        private TableAndFile(File databaseDir, long fileNumber, UserComparator userComparator, boolean verifyChecksums) throws IOException {
            String tableFileName = Filename.tableFileName(fileNumber);
            File tableFile = new File(databaseDir, tableFileName);
            try (FileInputStream fis = new FileInputStream(tableFile);
                 FileChannel fileChannel = fis.getChannel();){
                this.table = Iq80DBFactory.USE_MMAP ? new MMapTable(tableFile.getAbsolutePath(), fileChannel, userComparator, verifyChecksums) : new FileChannelTable(tableFile.getAbsolutePath(), fileChannel, userComparator, verifyChecksums);
            }
        }

        public Table getTable() {
            return this.table;
        }
    }
}

