/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.VersionEditTag;
import org.iq80.leveldb.util.DynamicSliceOutput;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.VariableLengthQuantity;

public class VersionEdit {
    private final Map<Integer, InternalKey> compactPointers = Maps.newTreeMap();
    private final Multimap<Integer, FileMetaData> newFiles = ArrayListMultimap.create();
    private final Multimap<Integer, Long> deletedFiles = ArrayListMultimap.create();
    private String comparatorName;
    private Long logNumber;
    private Long nextFileNumber;
    private Long previousLogNumber;
    private Long lastSequenceNumber;

    public VersionEdit() {
    }

    public VersionEdit(Slice slice) {
        SliceInput sliceInput = slice.input();
        while (sliceInput.isReadable()) {
            int i = VariableLengthQuantity.readVariableLengthInt(sliceInput);
            VersionEditTag tag = VersionEditTag.getValueTypeByPersistentId(i);
            tag.readValue(sliceInput, this);
        }
    }

    public String getComparatorName() {
        return this.comparatorName;
    }

    public void setComparatorName(String comparatorName) {
        this.comparatorName = comparatorName;
    }

    public Long getLogNumber() {
        return this.logNumber;
    }

    public void setLogNumber(long logNumber) {
        this.logNumber = logNumber;
    }

    public Long getNextFileNumber() {
        return this.nextFileNumber;
    }

    public void setNextFileNumber(long nextFileNumber) {
        this.nextFileNumber = nextFileNumber;
    }

    public Long getPreviousLogNumber() {
        return this.previousLogNumber;
    }

    public void setPreviousLogNumber(long previousLogNumber) {
        this.previousLogNumber = previousLogNumber;
    }

    public Long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public void setLastSequenceNumber(long lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
    }

    public Map<Integer, InternalKey> getCompactPointers() {
        return ImmutableMap.copyOf(this.compactPointers);
    }

    public void setCompactPointers(Map<Integer, InternalKey> compactPointers) {
        this.compactPointers.putAll(compactPointers);
    }

    public void setCompactPointer(int level, InternalKey key) {
        this.compactPointers.put(level, key);
    }

    public Multimap<Integer, FileMetaData> getNewFiles() {
        return ImmutableMultimap.copyOf(this.newFiles);
    }

    public void addFile(int level, long fileNumber, long fileSize, InternalKey smallest, InternalKey largest) {
        FileMetaData fileMetaData = new FileMetaData(fileNumber, fileSize, smallest, largest);
        this.addFile(level, fileMetaData);
    }

    public void addFile(int level, FileMetaData fileMetaData) {
        this.newFiles.put((Object)level, (Object)fileMetaData);
    }

    public void addFiles(Multimap<Integer, FileMetaData> files) {
        this.newFiles.putAll(files);
    }

    public Multimap<Integer, Long> getDeletedFiles() {
        return ImmutableMultimap.copyOf(this.deletedFiles);
    }

    public void deleteFile(int level, long fileNumber) {
        this.deletedFiles.put((Object)level, (Object)fileNumber);
    }

    public Slice encode() {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(4096);
        for (VersionEditTag versionEditTag : VersionEditTag.values()) {
            versionEditTag.writeValue(dynamicSliceOutput, this);
        }
        return dynamicSliceOutput.slice();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VersionEdit");
        sb.append("{comparatorName='").append(this.comparatorName).append('\'');
        sb.append(", logNumber=").append(this.logNumber);
        sb.append(", previousLogNumber=").append(this.previousLogNumber);
        sb.append(", lastSequenceNumber=").append(this.lastSequenceNumber);
        sb.append(", compactPointers=").append(this.compactPointers);
        sb.append(", newFiles=").append(this.newFiles);
        sb.append(", deletedFiles=").append(this.deletedFiles);
        sb.append('}');
        return sb.toString();
    }
}

