/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Charsets;
import java.util.Map;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.VariableLengthQuantity;

public enum VersionEditTag {
    COMPARATOR(1){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            byte[] bytes = new byte[VariableLengthQuantity.readVariableLengthInt(sliceInput)];
            sliceInput.readBytes(bytes);
            versionEdit.setComparatorName(new String(bytes, Charsets.UTF_8));
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            String comparatorName = versionEdit.getComparatorName();
            if (comparatorName != null) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                byte[] bytes = comparatorName.getBytes(Charsets.UTF_8);
                VariableLengthQuantity.writeVariableLengthInt(bytes.length, sliceOutput);
                sliceOutput.writeBytes(bytes);
            }
        }
    }
    ,
    LOG_NUMBER(2){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            versionEdit.setLogNumber(VariableLengthQuantity.readVariableLengthLong(sliceInput));
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            Long logNumber = versionEdit.getLogNumber();
            if (logNumber != null) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong(logNumber, sliceOutput);
            }
        }
    }
    ,
    PREVIOUS_LOG_NUMBER(9){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            long previousLogNumber = VariableLengthQuantity.readVariableLengthLong(sliceInput);
            versionEdit.setPreviousLogNumber(previousLogNumber);
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            Long previousLogNumber = versionEdit.getPreviousLogNumber();
            if (previousLogNumber != null) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong(previousLogNumber, sliceOutput);
            }
        }
    }
    ,
    NEXT_FILE_NUMBER(3){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            versionEdit.setNextFileNumber(VariableLengthQuantity.readVariableLengthLong(sliceInput));
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            Long nextFileNumber = versionEdit.getNextFileNumber();
            if (nextFileNumber != null) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong(nextFileNumber, sliceOutput);
            }
        }
    }
    ,
    LAST_SEQUENCE(4){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            versionEdit.setLastSequenceNumber(VariableLengthQuantity.readVariableLengthLong(sliceInput));
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            Long lastSequenceNumber = versionEdit.getLastSequenceNumber();
            if (lastSequenceNumber != null) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong(lastSequenceNumber, sliceOutput);
            }
        }
    }
    ,
    COMPACT_POINTER(5){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            int level = VariableLengthQuantity.readVariableLengthInt(sliceInput);
            InternalKey internalKey = new InternalKey(Slices.readLengthPrefixedBytes(sliceInput));
            versionEdit.setCompactPointer(level, internalKey);
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            for (Map.Entry<Integer, InternalKey> entry : versionEdit.getCompactPointers().entrySet()) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthInt(entry.getKey(), sliceOutput);
                Slices.writeLengthPrefixedBytes(sliceOutput, entry.getValue().encode());
            }
        }
    }
    ,
    DELETED_FILE(6){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            int level = VariableLengthQuantity.readVariableLengthInt(sliceInput);
            long fileNumber = VariableLengthQuantity.readVariableLengthLong(sliceInput);
            versionEdit.deleteFile(level, fileNumber);
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            for (Map.Entry entry : versionEdit.getDeletedFiles().entries()) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthInt((Integer)entry.getKey(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong((Long)entry.getValue(), sliceOutput);
            }
        }
    }
    ,
    NEW_FILE(7){

        @Override
        public void readValue(SliceInput sliceInput, VersionEdit versionEdit) {
            int level = VariableLengthQuantity.readVariableLengthInt(sliceInput);
            long fileNumber = VariableLengthQuantity.readVariableLengthLong(sliceInput);
            long fileSize = VariableLengthQuantity.readVariableLengthLong(sliceInput);
            InternalKey smallestKey = new InternalKey(Slices.readLengthPrefixedBytes(sliceInput));
            InternalKey largestKey = new InternalKey(Slices.readLengthPrefixedBytes(sliceInput));
            versionEdit.addFile(level, fileNumber, fileSize, smallestKey, largestKey);
        }

        @Override
        public void writeValue(SliceOutput sliceOutput, VersionEdit versionEdit) {
            for (Map.Entry entry : versionEdit.getNewFiles().entries()) {
                VariableLengthQuantity.writeVariableLengthInt(this.getPersistentId(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthInt((Integer)entry.getKey(), sliceOutput);
                FileMetaData fileMetaData = (FileMetaData)entry.getValue();
                VariableLengthQuantity.writeVariableLengthLong(fileMetaData.getNumber(), sliceOutput);
                VariableLengthQuantity.writeVariableLengthLong(fileMetaData.getFileSize(), sliceOutput);
                Slices.writeLengthPrefixedBytes(sliceOutput, fileMetaData.getSmallest().encode());
                Slices.writeLengthPrefixedBytes(sliceOutput, fileMetaData.getLargest().encode());
            }
        }
    };

    private final int persistentId;

    private VersionEditTag(int persistentId) {
        this.persistentId = persistentId;
    }

    public static VersionEditTag getValueTypeByPersistentId(int persistentId) {
        for (VersionEditTag compressionType : VersionEditTag.values()) {
            if (compressionType.persistentId != persistentId) continue;
            return compressionType;
        }
        throw new IllegalArgumentException(String.format("Unknown %s persistentId %d", VersionEditTag.class.getSimpleName(), persistentId));
    }

    public int getPersistentId() {
        return this.persistentId;
    }

    public abstract void readValue(SliceInput var1, VersionEdit var2);

    public abstract void writeValue(SliceOutput var1, VersionEdit var2);
}

