/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.table.BlockIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;

public class Block
implements SeekingIterable<Slice, Slice> {
    private final Slice block;
    private final Comparator<Slice> comparator;
    private final Slice data;
    private final Slice restartPositions;

    public Block(Slice block, Comparator<Slice> comparator) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkArgument((block.length() >= 4 ? 1 : 0) != 0, (String)"Block is corrupt: size must be at least %s block", (int)4);
        Preconditions.checkNotNull(comparator, (Object)"comparator is null");
        this.block = block = block.slice();
        this.comparator = comparator;
        int restartCount = block.getInt(block.length() - 4);
        if (restartCount > 0) {
            int restartOffset = block.length() - (1 + restartCount) * 4;
            Preconditions.checkArgument((restartOffset < block.length() - 4 ? 1 : 0) != 0, (Object)"Block is corrupt: restart offset count is greater than block size");
            this.restartPositions = block.slice(restartOffset, restartCount * 4);
            this.data = block.slice(0, restartOffset);
        } else {
            this.data = Slices.EMPTY_SLICE;
            this.restartPositions = Slices.EMPTY_SLICE;
        }
    }

    public long size() {
        return this.block.length();
    }

    public BlockIterator iterator() {
        return new BlockIterator(this.data, this.restartPositions, this.comparator);
    }
}

