/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.table.BlockTrailer;
import org.iq80.leveldb.table.Footer;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.util.ByteBufferSupport;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.Snappy;
import org.iq80.leveldb.util.Zlib;

public class MMapTable
extends Table {
    private MappedByteBuffer data;

    public MMapTable(String name, FileChannel fileChannel, Comparator<Slice> comparator, boolean verifyChecksums) throws IOException {
        super(name, fileChannel, comparator, verifyChecksums);
        Preconditions.checkArgument((fileChannel.size() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"File must be smaller than %s bytes", (int)Integer.MAX_VALUE);
    }

    public static ByteBuffer read(MappedByteBuffer data, int offset, int length) {
        int newPosition = data.position() + offset;
        return (ByteBuffer)data.duplicate().order(ByteOrder.LITTLE_ENDIAN).clear().limit(newPosition + length).position(newPosition);
    }

    @Override
    protected Footer init() throws IOException {
        long size = this.fileChannel.size();
        this.data = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Slice footerSlice = Slices.copiedBuffer(this.data, (int)size - 48, 48);
        return Footer.readFooter(footerSlice);
    }

    @Override
    public Callable<?> closer() {
        return new Closer(this.name, this.fileChannel, this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Block readBlock(BlockHandle blockHandle) throws IOException {
        Slice uncompressedData;
        BlockTrailer blockTrailer = BlockTrailer.readBlockTrailer(Slices.copiedBuffer(this.data, (int)blockHandle.getOffset() + blockHandle.getDataSize(), 5));
        ByteBuffer uncompressedBuffer = MMapTable.read(this.data, (int)blockHandle.getOffset(), blockHandle.getDataSize());
        if (blockTrailer.getCompressionType() == CompressionType.ZLIB_RAW) {
            Class<MMapTable> clazz = MMapTable.class;
            synchronized (MMapTable.class) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(blockHandle.getDataSize() * 5);
                Zlib.uncompressRaw(uncompressedBuffer, stream);
                uncompressedData = Slices.wrappedBuffer(stream.toByteArray());
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return new Block(uncompressedData, this.comparator);
            }
        } else if (blockTrailer.getCompressionType() == CompressionType.ZLIB) {
            Class<MMapTable> clazz = MMapTable.class;
            synchronized (MMapTable.class) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(blockHandle.getDataSize() * 5);
                Zlib.uncompress(uncompressedBuffer, stream);
                uncompressedData = Slices.wrappedBuffer(stream.toByteArray());
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return new Block(uncompressedData, this.comparator);
            }
        } else if (blockTrailer.getCompressionType() == CompressionType.SNAPPY) {
            Class<MMapTable> clazz = MMapTable.class;
            synchronized (MMapTable.class) {
                int uncompressedLength = this.uncompressedLength(uncompressedBuffer);
                if (uncompressedScratch.capacity() < uncompressedLength) {
                    uncompressedScratch = ByteBuffer.allocateDirect(uncompressedLength);
                }
                uncompressedScratch.clear();
                Snappy.uncompress(uncompressedBuffer, uncompressedScratch);
                uncompressedData = Slices.copiedBuffer(uncompressedScratch);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return new Block(uncompressedData, this.comparator);
            }
        } else {
            uncompressedData = Slices.copiedBuffer(uncompressedBuffer);
        }
        return new Block(uncompressedData, this.comparator);
    }

    private static class Closer
    implements Callable<Void> {
        private final String name;
        private final Closeable closeable;
        private final MappedByteBuffer data;

        public Closer(String name, Closeable closeable, MappedByteBuffer data) {
            this.name = name;
            this.closeable = closeable;
            this.data = data;
        }

        @Override
        public Void call() {
            ByteBufferSupport.unmap(this.data);
            Closeables.closeQuietly(this.closeable);
            return null;
        }
    }
}

