/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.table.BlockIterator;
import org.iq80.leveldb.table.Footer;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.TableIterator;
import org.iq80.leveldb.util.VariableLengthQuantity;

public abstract class Table
implements SeekingIterable<Slice, Slice> {
    protected static ByteBuffer uncompressedScratch = ByteBuffer.allocateDirect(0x400000);
    protected final String name;
    protected final FileChannel fileChannel;
    protected final Comparator<Slice> comparator;
    protected final boolean verifyChecksums;
    protected final Block indexBlock;
    protected final BlockHandle metaindexBlockHandle;
    private LoadingCache<BlockHandle, Block> blockCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(blockHandle -> {
        Block dataBlock;
        try {
            dataBlock = this.readBlock((BlockHandle)blockHandle);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dataBlock;
    }));

    public Table(String name, FileChannel fileChannel, Comparator<Slice> comparator, boolean verifyChecksums) throws IOException {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)fileChannel, (Object)"fileChannel is null");
        long size = fileChannel.size();
        Preconditions.checkArgument((size >= 48L ? 1 : 0) != 0, (String)"File is corrupt: size must be at least %s bytes", (int)48);
        Preconditions.checkNotNull(comparator, (Object)"comparator is null");
        this.name = name;
        this.fileChannel = fileChannel;
        this.verifyChecksums = verifyChecksums;
        this.comparator = comparator;
        Footer footer = this.init();
        this.indexBlock = this.readBlock(footer.getIndexBlockHandle());
        this.metaindexBlockHandle = footer.getMetaindexBlockHandle();
    }

    protected abstract Footer init() throws IOException;

    public TableIterator iterator() {
        return new TableIterator(this, this.indexBlock.iterator());
    }

    public Block openBlock(Slice blockEntry) {
        BlockHandle blockHandle = BlockHandle.readBlockHandle(blockEntry.input());
        try {
            return (Block)this.blockCache.get((Object)blockHandle);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected abstract Block readBlock(BlockHandle var1) throws IOException;

    protected int uncompressedLength(ByteBuffer data) throws IOException {
        int length = VariableLengthQuantity.readVariableLengthInt(data.duplicate());
        return length;
    }

    public long getApproximateOffsetOf(Slice key) {
        BlockIterator iterator = this.indexBlock.iterator();
        iterator.seek(key);
        if (iterator.hasNext()) {
            BlockHandle blockHandle = BlockHandle.readBlockHandle(iterator.next().getValue().input());
            return blockHandle.getOffset();
        }
        return this.metaindexBlockHandle.getOffset();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", comparator=").append(this.comparator);
        sb.append(", verifyChecksums=").append(this.verifyChecksums);
        sb.append('}');
        return sb.toString();
    }

    public Callable<?> closer() {
        return new Closer(this.fileChannel);
    }

    public void clearBlockCache() {
        this.blockCache.invalidateAll();
    }

    private static class Closer
    implements Callable<Void> {
        private final Closeable closeable;

        public Closer(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public Void call() {
            Closeables.closeQuietly(this.closeable);
            return null;
        }
    }
}

