/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Zlib {
    private static final ZLibSPI ZLIB = new ZLibSPI(false);
    private static final ZLibSPI ZLIB_RAW = new ZLibSPI(true);

    public static boolean available() {
        return ZLIB != null && ZLIB_RAW != null;
    }

    public static void uncompress(ByteBuffer compressed, ByteArrayOutputStream uncompressed) throws IOException {
        ZLIB.uncompress(compressed, uncompressed);
    }

    public static void uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        ZLIB.uncompress(input, inputOffset, length, output, outputOffset);
    }

    public static int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        return ZLIB.compress(input, inputOffset, length, output, outputOffset);
    }

    public static byte[] compress(String text) throws IOException {
        return ZLIB.compress(text);
    }

    public static void uncompressRaw(ByteBuffer compressed, ByteArrayOutputStream uncompressed) throws IOException {
        ZLIB_RAW.uncompress(compressed, uncompressed);
    }

    public static void uncompressRaw(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        ZLIB_RAW.uncompress(input, inputOffset, length, output, outputOffset);
    }

    public static int compressRaw(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        return ZLIB_RAW.compress(input, inputOffset, length, output, outputOffset);
    }

    public static byte[] compressRaw(String text) throws IOException {
        return ZLIB_RAW.compress(text);
    }

    private static class ZLibSPI {
        private ThreadLocal<Deflater> deflaterThreadLocal = new ThreadLocal();
        private ThreadLocal<Inflater> inflaterThreadLocal = new ThreadLocal();
        private boolean raw;

        public ZLibSPI(boolean raw) {
            this.raw = raw;
        }

        private int copy(InputStream in, OutputStream out) throws IOException {
            int read;
            byte[] buffer = new byte[1024];
            int count = 0;
            while (-1 != (read = in.read(buffer))) {
                out.write(buffer, 0, read);
                count += read;
            }
            return count;
        }

        public int uncompress(ByteBuffer compressed, ByteArrayOutputStream uncompressed) throws IOException {
            Inflater inflater = this.inflaterThreadLocal.get();
            if (inflater == null) {
                inflater = new Inflater(this.raw);
                this.inflaterThreadLocal.set(inflater);
            }
            inflater.reset();
            byte[] data = new byte[compressed.remaining()];
            compressed.get(data);
            inflater.setInput(data);
            byte[] buffer = new byte[1024];
            int count = 0;
            try {
                int read;
                while ((read = inflater.inflate(buffer)) != 0) {
                    uncompressed.write(buffer, 0, read);
                    count += read;
                }
            }
            catch (DataFormatException e) {
                throw new IOException("Could not decompress data: ", e);
            }
            return count;
        }

        public int uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            Inflater inflater = this.inflaterThreadLocal.get();
            if (inflater == null) {
                inflater = new Inflater(this.raw);
                this.inflaterThreadLocal.set(inflater);
            }
            inflater.reset();
            return this.copy(new InflaterInputStream(new ByteArrayInputStream(input, inputOffset, length), inflater), new ByteBufferBackedOutputStream(ByteBuffer.wrap(output, outputOffset, output.length - outputOffset)));
        }

        public int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            Deflater deflater = this.deflaterThreadLocal.get();
            if (deflater == null) {
                deflater = new Deflater(-1, this.raw);
                this.deflaterThreadLocal.set(deflater);
            }
            deflater.reset();
            ByteBufferBackedOutputStream stream = new ByteBufferBackedOutputStream(ByteBuffer.wrap(output, outputOffset, output.length - outputOffset));
            return this.copy(new DeflaterInputStream(new ByteArrayInputStream(input, inputOffset, length), deflater), stream);
        }

        public byte[] compress(String text) throws IOException {
            Deflater deflater = this.deflaterThreadLocal.get();
            if (deflater == null) {
                deflater = new Deflater(-1, this.raw);
                this.deflaterThreadLocal.set(deflater);
            }
            deflater.reset();
            byte[] input = text.getBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.copy(new DeflaterInputStream(new ByteArrayInputStream(input, 0, input.length), deflater), baos);
            return baos.toByteArray();
        }
    }

    public static class ByteBufferBackedOutputStream
    extends OutputStream {
        ByteBuffer buf;

        public ByteBufferBackedOutputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public void write(int b) throws IOException {
            this.buf.put((byte)b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.buf.put(bytes, off, len);
        }
    }

    public static class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

