/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet.proxy;

import com.nukkitx.network.raknet.proxy.HAProxyMessage;
import com.nukkitx.network.raknet.proxy.HAProxyProtocolException;
import com.nukkitx.network.raknet.proxy.HAProxyProtocolVersion;
import com.nukkitx.network.raknet.proxy.ProxyProtocolConstants;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.util.CharsetUtil;

public final class ProxyProtocolDecoder
implements ProxyProtocolConstants {
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V1 = ProtocolDetectionResult.detected((Object)HAProxyProtocolVersion.V1);
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V2 = ProtocolDetectionResult.detected((Object)HAProxyProtocolVersion.V2);
    private HeaderExtractor headerExtractor;
    private boolean discarding;
    private int discardedBytes;
    private boolean finished;
    private int decodingVersion = -1;
    private final int v2MaxHeaderSize = 65551;

    private ProxyProtocolDecoder(int version) {
        this.decodingVersion = version;
    }

    public static HAProxyMessage decode(ByteBuf packet, int version) {
        if (version == -1) {
            return null;
        }
        ProxyProtocolDecoder decoder = new ProxyProtocolDecoder(version);
        return decoder.decodeHeader(packet);
    }

    private HAProxyMessage decodeHeader(ByteBuf in) {
        ByteBuf decoded;
        ByteBuf byteBuf = decoded = this.decodingVersion == 1 ? this.decodeLine(in) : this.decodeStruct(in);
        if (decoded == null) {
            return null;
        }
        this.finished = true;
        try {
            if (this.decodingVersion == 1) {
                return HAProxyMessage.decodeHeader(decoded.toString(CharsetUtil.US_ASCII));
            }
            return HAProxyMessage.decodeHeader(decoded);
        }
        catch (HAProxyProtocolException e) {
            throw this.fail(null, (Exception)((Object)e));
        }
    }

    public static int findVersion(ByteBuf buffer) {
        int n = buffer.readableBytes();
        if (n < 13) {
            return -1;
        }
        int idx = buffer.readerIndex();
        return ProxyProtocolDecoder.match(BINARY_PREFIX, buffer, idx) ? (int)buffer.getByte(idx + BINARY_PREFIX_LENGTH) : 1;
    }

    private ByteBuf decodeStruct(ByteBuf buffer) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new StructHeaderExtractor(65551);
        }
        return this.headerExtractor.extract(buffer);
    }

    private ByteBuf decodeLine(ByteBuf buffer) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new LineHeaderExtractor(108);
        }
        return this.headerExtractor.extract(buffer);
    }

    private void failOverLimit(String length) {
        int maxLength = this.decodingVersion == 1 ? 108 : 65551;
        throw this.fail("header length (" + length + ") exceeds the allowed maximum (" + maxLength + ')', null);
    }

    private HAProxyProtocolException fail(String errMsg, Exception e) {
        this.finished = true;
        HAProxyProtocolException ppex = errMsg != null && e != null ? new HAProxyProtocolException(errMsg, e) : (errMsg != null ? new HAProxyProtocolException(errMsg) : (e != null ? new HAProxyProtocolException(e) : new HAProxyProtocolException()));
        return ppex;
    }

    public static ProtocolDetectionResult<HAProxyProtocolVersion> detectProtocol(ByteBuf buffer) {
        if (buffer.readableBytes() < 12) {
            return ProtocolDetectionResult.needsMoreData();
        }
        int idx = buffer.readerIndex();
        if (ProxyProtocolDecoder.match(BINARY_PREFIX, buffer, idx)) {
            return DETECTION_RESULT_V2;
        }
        if (ProxyProtocolDecoder.match(TEXT_PREFIX, buffer, idx)) {
            return DETECTION_RESULT_V1;
        }
        return ProtocolDetectionResult.invalid();
    }

    private static boolean match(byte[] prefix, ByteBuf buffer, int idx) {
        for (int i = 0; i < prefix.length; ++i) {
            byte b = buffer.getByte(idx + i);
            if (b == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private final class StructHeaderExtractor
    extends HeaderExtractor {
        StructHeaderExtractor(int maxHeaderSize) {
            super(maxHeaderSize);
        }

        @Override
        protected int findEndOfHeader(ByteBuf buffer) {
            int n = buffer.readableBytes();
            if (n < 16) {
                return -1;
            }
            int offset = buffer.readerIndex() + 14;
            int totalHeaderBytes = 16 + buffer.getUnsignedShort(offset);
            if (n >= totalHeaderBytes) {
                return totalHeaderBytes;
            }
            return -1;
        }

        @Override
        protected int delimiterLength(ByteBuf buffer, int eoh) {
            return 0;
        }
    }

    private final class LineHeaderExtractor
    extends HeaderExtractor {
        LineHeaderExtractor(int maxHeaderSize) {
            super(maxHeaderSize);
        }

        @Override
        protected int findEndOfHeader(ByteBuf buffer) {
            int n = buffer.writerIndex();
            for (int i = buffer.readerIndex(); i < n; ++i) {
                byte b = buffer.getByte(i);
                if (b != 13 || i >= n - 1 || buffer.getByte(i + 1) != 10) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected int delimiterLength(ByteBuf buffer, int eoh) {
            return buffer.getByte(eoh) == 13 ? 2 : 1;
        }
    }

    private abstract class HeaderExtractor {
        private final int maxHeaderSize;

        protected HeaderExtractor(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
        }

        public ByteBuf extract(ByteBuf buffer) {
            int eoh = this.findEndOfHeader(buffer);
            if (!ProxyProtocolDecoder.this.discarding) {
                if (eoh >= 0) {
                    int length = eoh - buffer.readerIndex();
                    if (length > this.maxHeaderSize) {
                        buffer.readerIndex(eoh + this.delimiterLength(buffer, eoh));
                        ProxyProtocolDecoder.this.failOverLimit(String.valueOf(length));
                        return null;
                    }
                    ByteBuf frame = buffer.readSlice(length);
                    buffer.skipBytes(this.delimiterLength(buffer, eoh));
                    return frame;
                }
                int length = buffer.readableBytes();
                if (length > this.maxHeaderSize) {
                    ProxyProtocolDecoder.this.discardedBytes = length;
                    buffer.skipBytes(length);
                    ProxyProtocolDecoder.this.discarding = true;
                    ProxyProtocolDecoder.this.failOverLimit("over " + ProxyProtocolDecoder.this.discardedBytes);
                }
                return null;
            }
            if (eoh >= 0) {
                int length = ProxyProtocolDecoder.this.discardedBytes + eoh - buffer.readerIndex();
                buffer.readerIndex(eoh + this.delimiterLength(buffer, eoh));
                ProxyProtocolDecoder.this.discardedBytes = 0;
                ProxyProtocolDecoder.this.discarding = false;
                ProxyProtocolDecoder.this.failOverLimit("over " + length);
            } else {
                ProxyProtocolDecoder.this.discardedBytes = ProxyProtocolDecoder.this.discardedBytes + buffer.readableBytes();
                buffer.skipBytes(buffer.readableBytes());
            }
            return null;
        }

        protected abstract int findEndOfHeader(ByteBuf var1);

        protected abstract int delimiterLength(ByteBuf var1, int var2);
    }
}

