/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.junit.jupiter;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.dispenser.DispenseBehaviorRegister;
import cn.nukkit.entity.Attribute;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Level;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.LevelProviderManager;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.generator.Flat;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.Nether;
import cn.nukkit.level.generator.Normal;
import cn.nukkit.potion.Effect;
import cn.nukkit.potion.Potion;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.powernukkit.tests.api.MockEntity;
import org.powernukkit.tests.api.MockLevel;
import org.powernukkit.tests.api.MockPlayer;
import org.powernukkit.tests.api.MockServer;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.mocks.EntityMocker;
import org.powernukkit.tests.mocks.LevelMocker;
import org.powernukkit.tests.mocks.Mocker;
import org.powernukkit.tests.mocks.PlayerMocker;
import org.powernukkit.tests.mocks.ServerMocker;

@API(since="0.1.0", status=API.Status.EXPERIMENTAL)
@MockServer(name="TinyTestServer", initPrivateFields=false, callsRealMethods=false, createTempDir=false)
public class PowerNukkitExtension
extends MockitoExtension
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace POWERNUKKIT = ExtensionContext.Namespace.create((Object[])new Object[]{"org.powernukkit"});
    private static final String SESSION = "session";
    @MockPlayer
    @MockLevel
    @MockEntity
    private static final Void defaults = null;

    public void beforeAll(ExtensionContext context) throws Exception {
        MockServer config = context.getRequiredTestClass().getAnnotation(MockServer.class);
        if (config == null) {
            config = PowerNukkitExtension.class.getAnnotation(MockServer.class);
        }
        Session session = new Session();
        ServerMocker serverMocker = new ServerMocker(config);
        Server server = serverMocker.create();
        session.serverMocker = serverMocker;
        context.getStore(POWERNUKKIT).put((Object)SESSION, (Object)session);
        serverMocker.setActive();
        this.initStatics(server);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Mocker playerMocker2;
        Session session = (Session)context.getStore(POWERNUKKIT).get((Object)SESSION, Session.class);
        Map<String, List<LevelMocker>> levels = session.levels;
        for (Object field : AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), MockLevel.class)) {
            if (!((AccessibleObject)field).isAnnotationPresent(MockLevel.class) || !((Field)field).getType().isAssignableFrom(Level.class)) continue;
            LevelMocker levelMocker = new LevelMocker(((Field)field).getAnnotation(MockLevel.class));
            Level level = levelMocker.create();
            levels.computeIfAbsent(levelMocker.getLevelName(), it -> new ArrayList()).add(levelMocker);
            ReflectionUtil.setField(testInstance, field, (Object)level);
        }
        Function<String, Level> levelProvider = name -> {
            if (name.isEmpty()) {
                if (!levels.isEmpty()) {
                    return ((LevelMocker)((List)levels.values().iterator().next()).get(0)).getLevel();
                }
                LevelMocker levelMocker = new LevelMocker();
                Level level = levelMocker.create();
                ArrayList<LevelMocker> list = new ArrayList<LevelMocker>();
                list.add(levelMocker);
                levels.put(levelMocker.getLevelName(), list);
                return level;
            }
            List list = levels.computeIfAbsent((String)name, it -> new ArrayList());
            if (list.size() > 1) {
                throw new IllegalStateException("Multiple level options: " + list);
            }
            if (list.size() == 1) {
                return ((LevelMocker)list.get(0)).getLevel();
            }
            LevelMocker levelMocker = new LevelMocker((String)name);
            Level level = levelMocker.create();
            list.add(levelMocker);
            return level;
        };
        for (Field field : AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), MockEntity.class)) {
            playerMocker2 = new EntityMocker(levelProvider, field.getAnnotation(MockEntity.class));
            playerMocker2.createAndSet(testInstance, field);
            session.entities.add((EntityMocker)playerMocker2);
        }
        for (Field field : AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), MockPlayer.class)) {
            playerMocker2 = new PlayerMocker(levelProvider, field.getAnnotation(MockPlayer.class));
            ((PlayerMocker)playerMocker2).prepare();
            playerMocker2.setInstance(testInstance);
            playerMocker2.setInstanceField(field);
            session.players.computeIfAbsent(((PlayerMocker)playerMocker2).getPlayerName(), it -> new ArrayList()).add(playerMocker2);
        }
        Map loadedLevels = session.serverMocker.getConfig().callsRealMethods() ? session.serverMocker.getServer().getLevels() : new LinkedHashMap();
        levels.values().stream().flatMap(Collection::stream).map(LevelMocker::getLevel).forEachOrdered(mock -> loadedLevels.put(mock.getId(), mock));
        Level defaultLevel = levels.values().stream().flatMap(Collection::stream).filter(mocker -> mocker.getConfig().isDefault()).map(LevelMocker::getLevel).findFirst().orElseGet(() -> levels.values().stream().flatMap(Collection::stream).findFirst().map(LevelMocker::getLevel).orElse(null));
        if (!session.serverMocker.getConfig().callsRealMethods()) {
            Server server = session.serverMocker.getServer();
            Mockito.lenient().when((Object)server.getLevel(ArgumentMatchers.anyInt())).thenAnswer(call -> (Level)loadedLevels.get(call.getArgument(0, Integer.class)));
            Mockito.lenient().when((Object)server.getLevelByName(ArgumentMatchers.anyString())).thenAnswer(call -> loadedLevels.values().stream().filter(level -> level.getName().equals(call.getArgument(0))).findFirst().orElse(null));
            Mockito.lenient().when((Object)server.isLevelLoaded(ArgumentMatchers.anyString())).thenAnswer(call -> loadedLevels.values().stream().anyMatch(level -> level.getName().equals(call.getArgument(0))));
            Mockito.lenient().when((Object)server.getLevels()).thenReturn(loadedLevels);
        }
        session.serverMocker.getServer().setDefaultLevel(defaultLevel);
        session.players.values().stream().flatMap(Collection::stream).forEachOrdered(playerMocker -> ReflectionUtil.execute(playerMocker::recreate));
    }

    public void afterEach(ExtensionContext context) {
        try {
            ((Session)context.getStore(POWERNUKKIT).get((Object)SESSION, Session.class)).releaseResources();
        }
        finally {
            super.afterEach(context);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ((Session)context.getStore(POWERNUKKIT).remove((Object)SESSION, Session.class)).releaseResources();
        ServerMocker.setServerInstance(null);
    }

    private void initStatics(Server server) {
        ReflectionUtil.execute(() -> {
            Method method = Server.class.getDeclaredMethod("registerEntities", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)server, new Object[0]);
            method = Server.class.getDeclaredMethod("registerBlockEntities", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)server, new Object[0]);
        });
        Block.init();
        Enchantment.init();
        Item.init();
        EnumBiome.values();
        Effect.init();
        Potion.init();
        Attribute.init();
        DispenseBehaviorRegister.init();
        GlobalBlockPalette.getOrCreateRuntimeId((int)0, (int)0);
        LevelProviderManager.addProvider(null, Anvil.class);
        Generator.addGenerator(Flat.class, (String)"flat", (int)2);
        Generator.addGenerator(Normal.class, (String)"normal", (int)1);
        Generator.addGenerator(Normal.class, (String)"default", (int)1);
        Generator.addGenerator(Nether.class, (String)"nether", (int)3);
    }

    static class Session {
        ServerMocker serverMocker;
        Map<String, List<LevelMocker>> levels = new LinkedHashMap<String, List<LevelMocker>>();
        Map<String, List<PlayerMocker>> players = new LinkedHashMap<String, List<PlayerMocker>>();
        List<EntityMocker> entities = new ArrayList<EntityMocker>();

        Session() {
        }

        void releaseResources() {
            this.serverMocker.releaseResources();
        }
    }
}

