/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.entity.Entity;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.powernukkit.tests.api.MockEntity;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.junit.jupiter.PowerNukkitExtension;
import org.powernukkit.tests.mocks.AnnotationParser;
import org.powernukkit.tests.mocks.Mocker;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class EntityMocker
extends Mocker<Entity> {
    final Function<String, Level> levelSupplier;
    final MockEntity config;
    Entity entity;

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public EntityMocker(Function<String, Level> levelSupplier) {
        this(levelSupplier, ReflectionUtil.supply(() -> PowerNukkitExtension.class.getDeclaredField("defaults").getAnnotation(MockEntity.class)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public EntityMocker(Function<String, Level> levelSupplier, MockEntity config) {
        this.levelSupplier = levelSupplier;
        this.config = config;
    }

    @Override
    public Entity create() {
        int chunkZ;
        Level level = this.levelSupplier.apply(this.config.level());
        Vector3 pos = AnnotationParser.parseVector3(this.config.position());
        CompoundTag nbt = Entity.getDefaultNBT((Vector3)pos, (Vector3)new Vector3(), (float)this.config.yaw(), (float)this.config.pitch());
        int chunkX = pos.getChunkX();
        BaseFullChunk chunk = level.getChunk(chunkX, chunkZ = pos.getChunkZ());
        if (chunk == null) {
            chunk = (BaseFullChunk)Mockito.mock(BaseFullChunk.class);
            LevelProvider provider = (LevelProvider)Mockito.mock(LevelProvider.class);
            Mockito.lenient().when((Object)provider.getChunk(ArgumentMatchers.eq((int)chunkX), ArgumentMatchers.eq((int)chunkZ))).thenReturn((Object)chunk);
            Mockito.lenient().when((Object)provider.getLevel()).thenReturn((Object)level);
            Mockito.lenient().when((Object)chunk.getX()).thenReturn((Object)chunkX);
            Mockito.lenient().when((Object)chunk.getZ()).thenReturn((Object)chunkZ);
            Mockito.lenient().when((Object)chunk.getProvider()).thenReturn((Object)provider);
        }
        this.entity = (Entity)Mockito.mock(this.config.type(), (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).useConstructor(new Object[]{chunk, nbt}));
        this.entity.noDamageTicks = 0;
        return this.entity;
    }
}

