/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import java.lang.reflect.Field;
import org.apiguardian.api.API;
import org.powernukkit.tests.api.ReflectionUtil;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public abstract class Mocker<T> {
    private Field instanceField;
    private Object instance;

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public abstract T create() throws ReflectiveOperationException;

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public final void createAndSet(Object instance, Field field) throws ReflectiveOperationException {
        this.setInstance(instance);
        this.setInstanceField(field);
        T mock = this.create();
        ReflectionUtil.setField(instance, field, mock);
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void recreate() throws ReflectiveOperationException {
        T mock = this.create();
        Field field = this.getInstanceField();
        if (field != null) {
            ReflectionUtil.setField(this.getInstance(), field, mock);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Field getInstanceField() {
        return this.instanceField;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Object getInstance() {
        return this.instance;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void setInstance(Object instance) {
        this.instance = instance;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void setInstanceField(Field instanceField) {
        this.instanceField = instanceField;
    }
}

