/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.powernukkit.tests.api.MockPlayer;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.junit.jupiter.PowerNukkitExtension;
import org.powernukkit.tests.mocks.AnnotationParser;
import org.powernukkit.tests.mocks.Mocker;

public class PlayerMocker
extends Mocker<Player> {
    final Function<String, Level> levelSupplier;
    final MockPlayer config;
    Level level;
    Player player;
    String playerName;

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public PlayerMocker(Function<String, Level> levelSupplier) {
        this(levelSupplier, ReflectionUtil.supply(() -> PowerNukkitExtension.class.getDeclaredField("defaults").getAnnotation(MockPlayer.class)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public PlayerMocker(Function<String, Level> levelSupplier, MockPlayer config) {
        this.config = config;
        this.levelSupplier = levelSupplier;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void prepare() {
        this.level = this.levelSupplier.apply(this.config.level());
        String name = this.config.name();
        if (name.isEmpty() && (name = "TestPlayer" + ThreadLocalRandom.current().nextInt(0, 999999)).length() > 16) {
            name = name.substring(0, 16);
        }
        this.playerName = name;
    }

    @Override
    public Player create() {
        int clientPort;
        String clientIp;
        int chunkZ;
        Vector3 pos = AnnotationParser.parseVector3(this.config.position());
        int chunkX = pos.getChunkX();
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ = pos.getChunkZ());
        if (chunk == null) {
            chunk = (BaseFullChunk)Mockito.mock(BaseFullChunk.class);
            LevelProvider provider = (LevelProvider)Mockito.mock(LevelProvider.class);
            Mockito.lenient().when((Object)provider.getChunk(ArgumentMatchers.eq((int)chunkX), ArgumentMatchers.eq((int)chunkZ))).thenReturn((Object)chunk);
            Mockito.lenient().when((Object)provider.getLevel()).thenReturn((Object)this.level);
            ((BaseFullChunk)Mockito.lenient().doCallRealMethod().when((Object)chunk)).setPosition(Mockito.anyInt(), Mockito.anyInt());
            chunk.setPosition(chunkX, chunkZ);
            Mockito.lenient().when((Object)chunk.getProvider()).thenReturn((Object)provider);
        }
        Skin skin = new Skin();
        skin.setSkinId("TestSkin" + ThreadLocalRandom.current().nextDouble());
        skin.setSkinData(new BufferedImage(64, 32, 4));
        Assertions.assertTrue((boolean)skin.isValid());
        SourceInterface sourceInterface = (SourceInterface)Mockito.mock(SourceInterface.class);
        long clientId = this.config.clientId();
        if (clientId == 0L) {
            clientId = ThreadLocalRandom.current().nextLong();
        }
        if ((clientIp = this.config.clientIp()).isEmpty()) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            clientIp = random.nextInt(1, 255) + "." + random.nextInt(1, 255) + "." + random.nextInt(1, 255) + "." + random.nextInt(1, 255);
        }
        if ((clientPort = this.config.clientPort()) == 0) {
            clientPort = ThreadLocalRandom.current().nextInt(1, 65535);
        }
        this.player = (Player)Mockito.mock(Player.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).useConstructor(new Object[]{sourceInterface, clientId, clientIp, clientPort}));
        LoginPacket loginPacket = new LoginPacket();
        loginPacket.username = this.playerName;
        loginPacket.protocol = ProtocolInfo.CURRENT_PROTOCOL;
        loginPacket.clientId = clientId;
        loginPacket.clientUUID = this.config.clientUUID().length == 2 ? new UUID(this.config.clientUUID()[0], this.config.clientUUID()[1]) : UUID.randomUUID();
        loginPacket.skin = skin;
        loginPacket.putLInt(2);
        loginPacket.put("{}".getBytes());
        loginPacket.putLInt(0);
        ReflectionUtil.execute(() -> ReflectionUtil.setField((Object)Server.getInstance(), Server.class.getDeclaredField("defaultLevel"), (Object)this.level));
        ((Server)Mockito.doCallRealMethod().when((Object)Server.getInstance())).getDefaultLevel();
        ((Level)Mockito.doReturn((Object)new Position(pos.x, pos.y, pos.z, this.level)).when((Object)this.level)).getSafeSpawn();
        this.player.handleDataPacket((DataPacket)loginPacket);
        Assertions.assertNotNull((Object)this.player.namedTag, () -> "Failed to initialize the player mock for " + this.getPlayerName());
        ReflectionUtil.execute(() -> {
            Method method = Player.class.getDeclaredMethod("completeLoginSequence", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.player, new Object[0]);
        });
        Assertions.assertTrue((boolean)this.player.isOnline(), (String)"Failed to make the fake player login");
        ReflectionUtil.execute(() -> {
            Method method = Player.class.getDeclaredMethod("doFirstSpawn", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.player, new Object[0]);
        });
        this.player.yaw = this.config.yaw();
        this.player.pitch = this.config.pitch();
        this.player.setHealth(this.config.health());
        this.player.noDamageTicks = 0;
        return this.player;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Player getPlayer() {
        return this.player;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public String getPlayerName() {
        return this.playerName;
    }
}

