/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class LogLevelAdjuster {
    private final Map<Class<?>, Level> adjustedClasses = new LinkedHashMap();

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public synchronized void setLevel(Class<?> c, Level level) {
        this.adjustedClasses.computeIfAbsent(c, this::getLevel);
        this.applyLevel(c, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void onlyNow(Class<?> c, Level level, Runnable runnable) {
        Level original = this.getLevel(c);
        this.setLevel(c, level);
        try {
            runnable.run();
        }
        finally {
            this.setLevel(c, original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public <V> V onlyNow(Class<?> c, Level level, Callable<V> runnable) throws Exception {
        Level original = this.getLevel(c);
        this.setLevel(c, level);
        try {
            V v = runnable.call();
            return v;
        }
        finally {
            this.setLevel(c, original);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Level getLevel(Class<?> c) {
        return LogManager.getLogger(c).getLevel();
    }

    private void applyLevel(Class<?> c, Level level) {
        Configurator.setLevel((String)LogManager.getLogger(c).getName(), (Level)level);
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public synchronized void restoreLevel(Class<?> c) {
        Level level = this.adjustedClasses.remove(c);
        if (level != null) {
            this.applyLevel(c, level);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public synchronized void restoreLevels() {
        this.adjustedClasses.forEach(this::applyLevel);
        this.adjustedClasses.clear();
    }
}

