/*
 * Decompiled with CFR 0.152.
 */
package processing.lwjgl;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBES2Compatibility;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMapBufferRange;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.GL21C;
import org.lwjgl.system.MemoryStack;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.lwjgl.tess.PGLU;
import processing.lwjgl.tess.PGLUtessellator;
import processing.lwjgl.tess.PGLUtessellatorCallbackAdapter;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class PLWJGL
extends PGL {
    public static final String P2D = "processing.lwjgl.PGraphicsLWJGL2D";
    public static final String P3D = "processing.lwjgl.PGraphicsLWJGL3D";
    public static int profile;
    public PGLU glu = new PGLU();
    protected FloatBuffer projMatrix;
    protected FloatBuffer mvMatrix;

    public PLWJGL(PGraphicsOpenGL pg) {
        super(pg);
    }

    protected static ByteBuffer allocateDirectByteBuffer(int size) {
        return BufferUtils.createByteBuffer((int)size);
    }

    protected static ShortBuffer allocateDirectShortBuffer(int size) {
        return BufferUtils.createShortBuffer((int)size);
    }

    protected static IntBuffer allocateDirectIntBuffer(int size) {
        return BufferUtils.createIntBuffer((int)size);
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int size) {
        return BufferUtils.createFloatBuffer((int)size);
    }

    private FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    private FontRenderContext getFontRenderContext(Font font) {
        return this.getFontMetrics(font).getFontRenderContext();
    }

    protected int getFontAscent(Object font) {
        return this.getFontMetrics((Font)font).getAscent();
    }

    protected int getFontDescent(Object font) {
        return this.getFontMetrics((Font)font).getDescent();
    }

    protected int getTextWidth(Object font, char[] buffer, int start, int stop) {
        int length = stop - start;
        FontMetrics metrics = this.getFontMetrics((Font)font);
        return metrics.charsWidth(buffer, start, length);
    }

    protected Object getDerivedFont(Object font, float size) {
        return ((Font)font).deriveFont(size);
    }

    protected Tessellator createTessellator(PGL.TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    protected String tessError(int err) {
        return PGLU.gluErrorString(err);
    }

    protected FontOutline createFontOutline(char ch, Object font) {
        return new FontOutline(ch, (Font)font);
    }

    public void flush() {
        GL21C.glFlush();
    }

    public void finish() {
        GL21C.glFinish();
    }

    public void hint(int target, int hint) {
        GL21C.glHint((int)target, (int)hint);
    }

    public void enable(int value) {
        if (-1 < value) {
            GL21C.glEnable((int)value);
        }
    }

    public void disable(int value) {
        if (-1 < value) {
            GL21C.glDisable((int)value);
        }
    }

    public void getBooleanv(int value, IntBuffer data) {
        if (-1 < value) {
            if (this.byteBuffer.capacity() < data.capacity()) {
                this.byteBuffer = PLWJGL.allocateDirectByteBuffer(data.capacity());
            }
            GL21C.glGetBooleanv((int)value, (ByteBuffer)this.byteBuffer);
            for (int i = 0; i < data.capacity(); ++i) {
                data.put(i, this.byteBuffer.get(i));
            }
        } else {
            PLWJGL.fillIntBuffer((IntBuffer)data, (int)0, (int)(data.capacity() - 1), (int)0);
        }
    }

    public void getIntegerv(int value, IntBuffer data) {
        if (-1 < value) {
            GL21C.glGetIntegerv((int)value, (IntBuffer)data);
        } else {
            PLWJGL.fillIntBuffer((IntBuffer)data, (int)0, (int)(data.capacity() - 1), (int)0);
        }
    }

    public void getFloatv(int value, FloatBuffer data) {
        if (-1 < value) {
            GL21C.glGetFloatv((int)value, (FloatBuffer)data);
        } else {
            PLWJGL.fillFloatBuffer((FloatBuffer)data, (int)0, (int)(data.capacity() - 1), (float)0.0f);
        }
    }

    public boolean isEnabled(int value) {
        return GL21C.glIsEnabled((int)value);
    }

    public String getString(int name) {
        return GL21C.glGetString((int)name);
    }

    public int getError() {
        return GL21C.glGetError();
    }

    public String errorString(int err) {
        switch (err) {
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enumerant";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: {
                return "out of memory";
            }
            case 1286: {
                return "invalid framebuffer operation";
            }
            case 32817: {
                return "table too large";
            }
        }
        return PGLU.gluErrorString(err);
    }

    public void genBuffers(int n, IntBuffer buffers) {
        buffers.limit(n);
        GL21C.glGenBuffers((IntBuffer)buffers);
        buffers.limit(buffers.capacity());
    }

    public void deleteBuffers(int n, IntBuffer buffers) {
        buffers.limit(n);
        GL21C.glDeleteBuffers((IntBuffer)buffers);
        buffers.limit(buffers.capacity());
    }

    public void bindBuffer(int target, int buffer) {
        GL21C.glBindBuffer((int)target, (int)buffer);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        if (data == null) {
            GL21C.glBufferData((int)target, (long)size, (int)usage);
        } else {
            if (data instanceof FloatBuffer) {
                data.limit(data.position() + size / 4);
                GL21C.glBufferData((int)target, (FloatBuffer)((FloatBuffer)data), (int)usage);
            } else if (data instanceof IntBuffer) {
                data.limit(data.position() + size / 4);
                GL21C.glBufferData((int)target, (IntBuffer)((IntBuffer)data), (int)usage);
            } else if (data instanceof ByteBuffer) {
                data.limit(data.position() + size);
                GL21C.glBufferData((int)target, (ByteBuffer)((ByteBuffer)data), (int)usage);
            } else if (data instanceof ShortBuffer) {
                data.limit(data.position() + size / 2);
                GL21C.glBufferData((int)target, (ShortBuffer)((ShortBuffer)data), (int)usage);
            }
            data.limit(data.capacity());
        }
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        if (data instanceof FloatBuffer) {
            data.limit(data.position() + size / 4);
            GL21C.glBufferSubData((int)target, (long)offset, (FloatBuffer)((FloatBuffer)data));
        } else if (data instanceof IntBuffer) {
            data.limit(data.position() + size / 4);
            GL21C.glBufferSubData((int)target, (long)offset, (IntBuffer)((IntBuffer)data));
        } else if (data instanceof ByteBuffer) {
            data.limit(data.position() + size);
            GL21C.glBufferSubData((int)target, (long)offset, (ByteBuffer)((ByteBuffer)data));
        } else if (data instanceof ShortBuffer) {
            data.limit(data.position() + size / 2);
            GL21C.glBufferSubData((int)target, (long)offset, (ShortBuffer)((ShortBuffer)data));
        }
        data.limit(data.capacity());
    }

    public void isBuffer(int buffer) {
        GL21C.glIsBuffer((int)buffer);
    }

    public void getBufferParameteriv(int target, int value, IntBuffer data) {
        if (-1 < value) {
            GL21C.glGetBufferParameteriv((int)target, (int)value, (IntBuffer)data);
        } else {
            data.put(0, 0);
        }
    }

    public ByteBuffer mapBuffer(int target, int access) {
        return GL21C.glMapBuffer((int)target, (int)access);
    }

    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        return ARBMapBufferRange.glMapBufferRange((int)target, (long)offset, (long)length, (int)access);
    }

    public void unmapBuffer(int target) {
        GL21C.glUnmapBuffer((int)target);
    }

    public long fenceSync(int condition, int flags) {
        return ARBSync.glFenceSync((int)condition, (int)flags);
    }

    public void deleteSync(long sync) {
        ARBSync.glDeleteSync((long)sync);
    }

    public int clientWaitSync(long sync, int flags, long timeout) {
        return ARBSync.glClientWaitSync((long)sync, (int)flags, (long)timeout);
    }

    public void depthRangef(float n, float f) {
        GL21C.glDepthRange((double)n, (double)f);
    }

    public void viewport(int x, int y, int w, int h) {
        float f = this.getPixelScale();
        this.viewportImpl((int)(f * (float)x), (int)(f * (float)y), (int)(f * (float)w), (int)(f * (float)h));
    }

    protected void viewportImpl(int x, int y, int w, int h) {
        GL21C.glViewport((int)x, (int)y, (int)w, (int)h);
    }

    protected void readPixelsImpl(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        GL21C.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)buffer));
    }

    protected void readPixelsImpl(int x, int y, int width, int height, int format, int type, long offset) {
        GL21C.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)offset);
    }

    public void vertexAttrib1f(int index, float value) {
        GL21C.glVertexAttrib1f((int)index, (float)value);
    }

    public void vertexAttrib2f(int index, float value0, float value1) {
        GL21C.glVertexAttrib2f((int)index, (float)value0, (float)value1);
    }

    public void vertexAttrib3f(int index, float value0, float value1, float value2) {
        GL21C.glVertexAttrib3f((int)index, (float)value0, (float)value1, (float)value2);
    }

    public void vertexAttrib4f(int index, float value0, float value1, float value2, float value3) {
        GL21C.glVertexAttrib4f((int)index, (float)value0, (float)value1, (float)value2, (float)value3);
    }

    public void vertexAttrib1fv(int index, FloatBuffer values) {
        GL21C.glVertexAttrib1fv((int)index, (FloatBuffer)values);
    }

    public void vertexAttrib2fv(int index, FloatBuffer values) {
        GL21C.glVertexAttrib2fv((int)index, (FloatBuffer)values);
    }

    public void vertexAttrib3fv(int index, FloatBuffer values) {
        GL21C.glVertexAttrib3fv((int)index, (FloatBuffer)values);
    }

    public void vertexAttrib4fv(int index, FloatBuffer values) {
        GL21C.glVertexAttrib4fv((int)index, (FloatBuffer)values);
    }

    public void vertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int offset) {
        GL21C.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)offset);
    }

    public void enableVertexAttribArray(int index) {
        GL21C.glEnableVertexAttribArray((int)index);
    }

    public void disableVertexAttribArray(int index) {
        GL21C.glDisableVertexAttribArray((int)index);
    }

    public void drawArraysImpl(int mode, int first, int count) {
        GL21C.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void drawElementsImpl(int mode, int count, int type, int offset) {
        GL21C.glDrawElements((int)mode, (int)count, (int)type, (long)offset);
    }

    public void lineWidth(float width) {
        GL21C.glLineWidth((float)width);
    }

    public void frontFace(int dir) {
        GL21C.glFrontFace((int)dir);
    }

    public void cullFace(int mode) {
        GL21C.glCullFace((int)mode);
    }

    public void polygonOffset(float factor, float units) {
        GL21C.glPolygonOffset((float)factor, (float)units);
    }

    public void pixelStorei(int pname, int param) {
        GL21C.glPixelStorei((int)pname, (int)param);
    }

    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        GL21C.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)((IntBuffer)data));
    }

    public void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        GL21C.glCopyTexImage2D((int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        GL21C.glTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)data));
    }

    public void copyTexSubImage2D(int target, int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        GL21C.glCopyTexSubImage2D((int)target, (int)level, (int)x, (int)y, (int)xOffset, (int)yOffset, (int)width, (int)height);
    }

    public void compressedTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int imageSize, Buffer data) {
        GL21C.glCompressedTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (ByteBuffer)((ByteBuffer)data));
    }

    public void compressedTexSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int imageSize, Buffer data) {
        GL21C.glCompressedTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (ByteBuffer)((ByteBuffer)data));
    }

    public void texParameteri(int target, int pname, int param) {
        GL21C.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void texParameterf(int target, int pname, float param) {
        GL21C.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void texParameteriv(int target, int pname, IntBuffer params) {
        GL21C.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void texParameterfv(int target, int pname, FloatBuffer params) {
        GL21C.glTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void generateMipmap(int target) {
        ARBFramebufferObject.glGenerateMipmap((int)target);
    }

    public void genTextures(int n, IntBuffer textures) {
        GL21C.glGenTextures((IntBuffer)textures);
    }

    public void deleteTextures(int n, IntBuffer textures) {
        GL21C.glDeleteTextures((IntBuffer)textures);
    }

    public void getTexParameteriv(int target, int pname, IntBuffer params) {
        GL21C.glGetTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void getTexParameterfv(int target, int pname, FloatBuffer params) {
        GL21C.glGetTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public boolean isTexture(int texture) {
        return GL21C.glIsTexture((int)texture);
    }

    protected void activeTextureImpl(int texture) {
        GL21C.glActiveTexture((int)texture);
    }

    protected void bindTextureImpl(int target, int texture) {
        GL21C.glBindTexture((int)target, (int)texture);
    }

    public int createShader(int type) {
        return GL21C.glCreateShader((int)type);
    }

    public void shaderSource(int shader, String source) {
        GL21C.glShaderSource((int)shader, (CharSequence)source);
    }

    public void compileShader(int shader) {
        GL21C.glCompileShader((int)shader);
    }

    public void releaseShaderCompiler() {
        ARBES2Compatibility.glReleaseShaderCompiler();
    }

    public void deleteShader(int shader) {
        GL21C.glDeleteShader((int)shader);
    }

    public void shaderBinary(int count, IntBuffer shaders, int binaryFormat, Buffer binary, int length) {
        ARBES2Compatibility.glShaderBinary((IntBuffer)shaders, (int)binaryFormat, (ByteBuffer)((ByteBuffer)binary));
    }

    public int createProgram() {
        return GL21C.glCreateProgram();
    }

    public void attachShader(int program, int shader) {
        GL21C.glAttachShader((int)program, (int)shader);
    }

    public void detachShader(int program, int shader) {
        GL21C.glDetachShader((int)program, (int)shader);
    }

    public void linkProgram(int program) {
        GL21C.glLinkProgram((int)program);
    }

    public void useProgram(int program) {
        GL21C.glUseProgram((int)program);
    }

    public void deleteProgram(int program) {
        GL21C.glDeleteProgram((int)program);
    }

    public String getActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        return GL21C.glGetActiveAttrib((int)program, (int)index, (IntBuffer)size, (IntBuffer)type);
    }

    public int getAttribLocation(int program, String name) {
        return GL21C.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public void bindAttribLocation(int program, int index, String name) {
        GL21C.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public int getUniformLocation(int program, String name) {
        return GL21C.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public String getActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        return GL21C.glGetActiveUniform((int)program, (int)index, (IntBuffer)size, (IntBuffer)type);
    }

    public void uniform1i(int location, int value) {
        GL21C.glUniform1i((int)location, (int)value);
    }

    public void uniform2i(int location, int value0, int value1) {
        GL21C.glUniform2i((int)location, (int)value0, (int)value1);
    }

    public void uniform3i(int location, int value0, int value1, int value2) {
        GL21C.glUniform3i((int)location, (int)value0, (int)value1, (int)value2);
    }

    public void uniform4i(int location, int value0, int value1, int value2, int value3) {
        GL21C.glUniform4i((int)location, (int)value0, (int)value1, (int)value2, (int)value3);
    }

    public void uniform1f(int location, float value) {
        GL21C.glUniform1f((int)location, (float)value);
    }

    public void uniform2f(int location, float value0, float value1) {
        GL21C.glUniform2f((int)location, (float)value0, (float)value1);
    }

    public void uniform3f(int location, float value0, float value1, float value2) {
        GL21C.glUniform3f((int)location, (float)value0, (float)value1, (float)value2);
    }

    public void uniform4f(int location, float value0, float value1, float value2, float value3) {
        GL21C.glUniform4f((int)location, (float)value0, (float)value1, (float)value2, (float)value3);
    }

    public void uniform1iv(int location, int count, IntBuffer v) {
        v.limit(count);
        GL21C.glUniform1iv((int)location, (IntBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform2iv(int location, int count, IntBuffer v) {
        v.limit(2 * count);
        GL21C.glUniform2iv((int)location, (IntBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform3iv(int location, int count, IntBuffer v) {
        v.limit(3 * count);
        GL21C.glUniform3iv((int)location, (IntBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform4iv(int location, int count, IntBuffer v) {
        v.limit(4 * count);
        GL21C.glUniform4iv((int)location, (IntBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform1fv(int location, int count, FloatBuffer v) {
        v.limit(count);
        GL21C.glUniform1fv((int)location, (FloatBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform2fv(int location, int count, FloatBuffer v) {
        v.limit(2 * count);
        GL21C.glUniform2fv((int)location, (FloatBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform3fv(int location, int count, FloatBuffer v) {
        v.limit(3 * count);
        GL21C.glUniform3fv((int)location, (FloatBuffer)v);
        v.limit(v.capacity());
    }

    public void uniform4fv(int location, int count, FloatBuffer v) {
        v.limit(4 * count);
        GL21C.glUniform4fv((int)location, (FloatBuffer)v);
        v.limit(v.capacity());
    }

    public void uniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer mat) {
        mat.limit(4 * count);
        GL21C.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)mat);
        mat.limit(mat.capacity());
    }

    public void uniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer mat) {
        mat.limit(9 * count);
        GL21C.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)mat);
        mat.limit(mat.capacity());
    }

    public void uniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer mat) {
        mat.limit(16 * count);
        GL21C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)mat);
        mat.limit(mat.capacity());
    }

    public void validateProgram(int program) {
        GL21C.glValidateProgram((int)program);
    }

    public boolean isShader(int shader) {
        return GL21C.glIsShader((int)shader);
    }

    public void getShaderiv(int shader, int pname, IntBuffer params) {
        GL21C.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
    }

    public void getAttachedShaders(int program, int maxCount, IntBuffer count, IntBuffer shaders) {
        GL21C.glGetAttachedShaders((int)program, (IntBuffer)count, (IntBuffer)shaders);
    }

    public String getShaderInfoLog(int shader) {
        int len = GL21C.glGetShaderi((int)shader, (int)35716);
        return GL21C.glGetShaderInfoLog((int)shader, (int)len);
    }

    public String getShaderSource(int shader) {
        int len = GL21C.glGetShaderi((int)shader, (int)35720);
        return GL21C.glGetShaderSource((int)shader, (int)len);
    }

    public void getShaderPrecisionFormat(int shaderType, int precisionType, IntBuffer range, IntBuffer precision) {
        ARBES2Compatibility.glGetShaderPrecisionFormat((int)shaderType, (int)precisionType, (IntBuffer)range, (IntBuffer)precision);
    }

    public void getVertexAttribfv(int index, int pname, FloatBuffer params) {
        GL21C.glGetVertexAttribfv((int)index, (int)pname, (FloatBuffer)params);
    }

    public void getVertexAttribiv(int index, int pname, IntBuffer params) {
        GL21C.glGetVertexAttribiv((int)index, (int)pname, (IntBuffer)params);
    }

    public void getVertexAttribPointerv(int index, int pname, ByteBuffer data) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buf = stack.mallocInt(1);
            GL21C.glGetIntegerv((int)34964, (IntBuffer)buf);
            if (buf.get(0) == 0) {
                throw new RuntimeException("no buffer is bound to GL_ARRAY_BUFFER");
            }
            PointerBuffer pb = stack.mallocPointer(data.remaining());
            GL21C.glGetVertexAttribPointerv((int)index, (int)pname, (PointerBuffer)pb);
            ByteBuffer bb = pb.getByteBuffer(pb.position(), pb.limit());
            data.put(bb);
        }
    }

    public void getUniformfv(int program, int location, FloatBuffer params) {
        GL21C.glGetUniformfv((int)program, (int)location, (FloatBuffer)params);
    }

    public void getUniformiv(int program, int location, IntBuffer params) {
        GL21C.glGetUniformiv((int)program, (int)location, (IntBuffer)params);
    }

    public boolean isProgram(int program) {
        return GL21C.glIsProgram((int)program);
    }

    public void getProgramiv(int program, int pname, IntBuffer params) {
        GL21C.glGetProgramiv((int)program, (int)pname, (IntBuffer)params);
    }

    public String getProgramInfoLog(int program) {
        int len = GL21C.glGetProgrami((int)program, (int)35716);
        return GL21C.glGetProgramInfoLog((int)program, (int)len);
    }

    public void scissor(int x, int y, int w, int h) {
        float f = this.graphics.pixelDensity;
        GL21C.glScissor((int)((int)(f * (float)x)), (int)((int)(f * (float)y)), (int)((int)f * w), (int)((int)(f * (float)h)));
    }

    public void sampleCoverage(float value, boolean invert) {
        GL21C.glSampleCoverage((float)value, (boolean)invert);
    }

    public void stencilFunc(int func, int ref, int mask) {
        GL21C.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void stencilFuncSeparate(int face, int func, int ref, int mask) {
        GL21C.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void stencilOp(int sfail, int dpfail, int dppass) {
        GL21C.glStencilOp((int)sfail, (int)dpfail, (int)dppass);
    }

    public void stencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        GL21C.glStencilOpSeparate((int)face, (int)sfail, (int)dpfail, (int)dppass);
    }

    public void depthFunc(int func) {
        GL21C.glDepthFunc((int)func);
    }

    public void blendEquation(int mode) {
        GL21C.glBlendEquation((int)mode);
    }

    public void blendEquationSeparate(int modeRGB, int modeAlpha) {
        GL21C.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void blendFunc(int src, int dst) {
        GL21C.glBlendFunc((int)src, (int)dst);
    }

    public void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL21C.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public void blendColor(float red, float green, float blue, float alpha) {
        GL21C.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void colorMask(boolean r, boolean g, boolean b, boolean a) {
        GL21C.glColorMask((boolean)r, (boolean)g, (boolean)b, (boolean)a);
    }

    public void depthMask(boolean mask) {
        GL21C.glDepthMask((boolean)mask);
    }

    public void stencilMask(int mask) {
        GL21C.glStencilMask((int)mask);
    }

    public void stencilMaskSeparate(int face, int mask) {
        GL21C.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void clearColor(float r, float g, float b, float a) {
        GL21C.glClearColor((float)r, (float)g, (float)b, (float)a);
    }

    public void clearDepth(float d) {
        GL21C.glClearDepth((double)d);
    }

    public void clearStencil(int s) {
        GL21C.glClearStencil((int)s);
    }

    public void clear(int buf) {
        GL21C.glClear((int)buf);
    }

    protected void bindFramebufferImpl(int target, int framebuffer) {
        ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebuffer);
    }

    public void deleteFramebuffers(int n, IntBuffer framebuffers) {
        ARBFramebufferObject.glDeleteFramebuffers((IntBuffer)framebuffers);
    }

    public void genFramebuffers(int n, IntBuffer framebuffers) {
        ARBFramebufferObject.glGenFramebuffers((IntBuffer)framebuffers);
    }

    public void bindRenderbuffer(int target, int renderbuffer) {
        ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    public void deleteRenderbuffers(int n, IntBuffer renderbuffers) {
        ARBFramebufferObject.glDeleteRenderbuffers((IntBuffer)renderbuffers);
    }

    public void genRenderbuffers(int n, IntBuffer renderbuffers) {
        ARBFramebufferObject.glGenRenderbuffers((IntBuffer)renderbuffers);
    }

    public void renderbufferStorage(int target, int internalFormat, int width, int height) {
        ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
    }

    public void framebufferRenderbuffer(int target, int attachment, int rendbuferfTarget, int renderbuffer) {
        ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)rendbuferfTarget, (int)renderbuffer);
    }

    public void framebufferTexture2D(int target, int attachment, int texTarget, int texture, int level) {
        ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)texTarget, (int)texture, (int)level);
    }

    public int checkFramebufferStatus(int target) {
        return ARBFramebufferObject.glCheckFramebufferStatus((int)target);
    }

    public boolean isFramebuffer(int framebuffer) {
        return ARBFramebufferObject.glIsFramebuffer((int)framebuffer);
    }

    public void getFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        ARBFramebufferObject.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)pname, (IntBuffer)params);
    }

    public boolean isRenderbuffer(int renderbuffer) {
        return ARBFramebufferObject.glIsRenderbuffer((int)renderbuffer);
    }

    public void getRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        ARBFramebufferObject.glGetRenderbufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        ARBFramebufferObject.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        ARBFramebufferObject.glRenderbufferStorageMultisample((int)target, (int)samples, (int)format, (int)width, (int)height);
    }

    public void readBuffer(int buf) {
        GL21C.glReadBuffer((int)buf);
    }

    public void drawBuffer(int buf) {
        GL21C.glDrawBuffer((int)buf);
    }

    protected void getGL(PGL pgl) {
        PLWJGL plwjgl = (PLWJGL)pgl;
        this.setThread(plwjgl.glThread);
        this.reqNumSamples = pgl.reqNumSamples;
    }

    public Object getNative() {
        return this.sketch.getSurface().getNative();
    }

    protected void setFrameRate(float fps) {
        this.sketch.getSurface().setFrameRate(fps);
    }

    protected void initSurface(int antialias) {
    }

    protected void reinitSurface() {
    }

    protected void registerListeners() {
    }

    protected int getDepthBits() {
        int frameBuffer = GL21C.glGetInteger((int)36006);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        int result = ARBFramebufferObject.glGetFramebufferAttachmentParameteri((int)36160, (int)6145, (int)33302);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)frameBuffer);
        return result;
    }

    protected int getStencilBits() {
        int frameBuffer = GL21C.glGetInteger((int)36006);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        int result = ARBFramebufferObject.glGetFramebufferAttachmentParameteri((int)36160, (int)6146, (int)33303);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)frameBuffer);
        return result;
    }

    protected float getPixelScale() {
        return this.graphics.pixelDensity;
    }

    protected boolean canDraw() {
        return true;
    }

    protected void requestFocus() {
    }

    protected void requestDraw() {
    }

    protected void swapBuffers() {
    }

    protected void initFBOLayer() {
        if (0 < this.sketch.frameCount) {
            if (this.isES()) {
                this.initFBOLayerES();
            } else {
                this.initFBOLayerGL();
            }
        }
    }

    protected int getGLSLVersion() {
        int spaceIndex;
        int end;
        String versionString;
        String[] parts;
        String versionVendorInfoString = GL21C.glGetString((int)SHADING_LANGUAGE_VERSION);
        if (versionVendorInfoString == null) {
            return 0;
        }
        String es2prefix = "OpenGL ES GLSL ES ";
        if (versionVendorInfoString.startsWith(es2prefix)) {
            versionVendorInfoString = versionVendorInfoString.substring(es2prefix.length());
        }
        if ((parts = (versionString = versionVendorInfoString.substring(0, end = (spaceIndex = versionVendorInfoString.indexOf(32)) >= 0 ? spaceIndex : versionVendorInfoString.length())).split("\\.")).length >= 2) {
            int major = PApplet.parseInt((String)parts[0], (int)0);
            int minor = PApplet.parseInt((String)parts[1], (int)0);
            return major * 100 + minor;
        }
        return 0;
    }

    protected String getGLSLVersionSuffix() {
        String versionVendorInfoString = GL21C.glGetString((int)SHADING_LANGUAGE_VERSION);
        if (versionVendorInfoString == null) {
            return null;
        }
        String es2prefix = "OpenGL ES GLSL ES ";
        if (versionVendorInfoString.startsWith(es2prefix)) {
            return " es";
        }
        return "";
    }

    protected String[] loadVertexShader(String filename) {
        return this.loadVertexShader(filename, this.getGLSLVersion(), this.getGLSLVersionSuffix());
    }

    protected String[] loadFragmentShader(String filename) {
        return this.loadFragmentShader(filename, this.getGLSLVersion(), this.getGLSLVersionSuffix());
    }

    protected String[] loadVertexShader(URL url) {
        return this.loadVertexShader(url, this.getGLSLVersion(), this.getGLSLVersionSuffix());
    }

    protected String[] loadFragmentShader(URL url) {
        return this.loadFragmentShader(url, this.getGLSLVersion(), this.getGLSLVersionSuffix());
    }

    protected String[] loadFragmentShader(String filename, int version, String versionSuffix) {
        String[] fragSrc0 = this.sketch.loadStrings(filename);
        return PLWJGL.preprocessFragmentSource((String[])fragSrc0, (int)version, (String)versionSuffix);
    }

    protected String[] loadVertexShader(String filename, int version, String versionSuffix) {
        String[] vertSrc0 = this.sketch.loadStrings(filename);
        return PLWJGL.preprocessVertexSource((String[])vertSrc0, (int)version, (String)versionSuffix);
    }

    protected String[] loadFragmentShader(URL url, int version, String versionSuffix) {
        try {
            String[] fragSrc0 = PApplet.loadStrings((InputStream)url.openStream());
            return PLWJGL.preprocessFragmentSource((String[])fragSrc0, (int)version, (String)versionSuffix);
        }
        catch (IOException e) {
            PGraphics.showException((String)("Cannot load fragment shader " + url.getFile()));
            return null;
        }
    }

    protected String[] loadVertexShader(URL url, int version, String versionSuffix) {
        try {
            String[] vertSrc0 = PApplet.loadStrings((InputStream)url.openStream());
            return PLWJGL.preprocessVertexSource((String[])vertSrc0, (int)version, (String)versionSuffix);
        }
        catch (IOException e) {
            PGraphics.showException((String)("Cannot load vertex shader " + url.getFile()));
            return null;
        }
    }

    private void initFBOLayerES() {
        IntBuffer buf = PLWJGL.allocateDirectIntBuffer(this.fboWidth * this.fboHeight);
        if (this.hasReadBuffer()) {
            this.readBuffer(BACK);
        }
        this.readPixelsImpl(0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex));
        this.texSubImage2D(TEXTURE_2D, 0, 0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.backTex));
        this.texSubImage2D(TEXTURE_2D, 0, 0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, 0);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
    }

    private void initFBOLayerGL() {
        if (this.pclearColor || 0 < this.pgeomCount || !this.sketch.isLooping()) {
            if (this.hasReadBuffer()) {
                this.readBuffer(FRONT);
            }
        } else {
            this.readBuffer(BACK);
        }
        this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.frontTex), 0);
        if (this.hasDrawBuffer()) {
            this.drawBuffer(COLOR_ATTACHMENT0);
        }
        this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, COLOR_BUFFER_BIT, NEAREST);
        this.readBuffer(BACK);
        this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
        this.drawBuffer(COLOR_ATTACHMENT0);
        this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, COLOR_BUFFER_BIT, NEAREST);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
    }

    static {
        MIN_DIRECT_BUFFER_SIZE = 16;
        INDEX_TYPE = 5123;
        SHAPE_TEXT_SUPPORTED = true;
        SEG_MOVETO = 0;
        SEG_LINETO = 1;
        SEG_QUADTO = 2;
        SEG_CUBICTO = 3;
        SEG_CLOSE = 4;
        FALSE = 0;
        TRUE = 1;
        INT = 5124;
        BYTE = 5120;
        SHORT = 5122;
        FLOAT = 5126;
        BOOL = 35670;
        UNSIGNED_INT = 5125;
        UNSIGNED_BYTE = 5121;
        UNSIGNED_SHORT = 5123;
        RGB = 6407;
        RGBA = 6408;
        ALPHA = 6406;
        LUMINANCE = 6409;
        LUMINANCE_ALPHA = 6410;
        UNSIGNED_SHORT_5_6_5 = 33635;
        UNSIGNED_SHORT_4_4_4_4 = 32819;
        UNSIGNED_SHORT_5_5_5_1 = 32820;
        RGBA4 = 32854;
        RGB5_A1 = 32855;
        RGB565 = 36194;
        RGB8 = 32849;
        RGBA8 = 32856;
        ALPHA8 = 32828;
        READ_ONLY = 35000;
        WRITE_ONLY = 35001;
        READ_WRITE = 35002;
        TESS_WINDING_NONZERO = 100131;
        TESS_WINDING_ODD = 100130;
        TESS_EDGE_FLAG = 100104;
        GENERATE_MIPMAP_HINT = 33170;
        FASTEST = 4353;
        NICEST = 4354;
        DONT_CARE = 4352;
        VENDOR = 7936;
        RENDERER = 7937;
        VERSION = 7938;
        EXTENSIONS = 7939;
        SHADING_LANGUAGE_VERSION = 35724;
        MAX_SAMPLES = 36183;
        SAMPLES = 32937;
        ALIASED_LINE_WIDTH_RANGE = 33902;
        ALIASED_POINT_SIZE_RANGE = 33901;
        DEPTH_BITS = 3414;
        STENCIL_BITS = 3415;
        CCW = 2305;
        CW = 2304;
        VIEWPORT = 2978;
        ARRAY_BUFFER = 34962;
        ELEMENT_ARRAY_BUFFER = 34963;
        PIXEL_PACK_BUFFER = 35051;
        MAX_VERTEX_ATTRIBS = 34921;
        STATIC_DRAW = 35044;
        DYNAMIC_DRAW = 35048;
        STREAM_DRAW = 35040;
        STREAM_READ = 35041;
        BUFFER_SIZE = 34660;
        BUFFER_USAGE = 34661;
        POINTS = 0;
        LINE_STRIP = 3;
        LINE_LOOP = 2;
        LINES = 1;
        TRIANGLE_FAN = 6;
        TRIANGLE_STRIP = 5;
        TRIANGLES = 4;
        CULL_FACE = 2884;
        FRONT = 1028;
        BACK = 1029;
        FRONT_AND_BACK = 1032;
        POLYGON_OFFSET_FILL = 32823;
        UNPACK_ALIGNMENT = 3317;
        PACK_ALIGNMENT = 3333;
        TEXTURE_2D = 3553;
        TEXTURE_RECTANGLE = 34037;
        TEXTURE_BINDING_2D = 32873;
        TEXTURE_BINDING_RECTANGLE = 34038;
        MAX_TEXTURE_SIZE = 3379;
        TEXTURE_MAX_ANISOTROPY = 34046;
        MAX_TEXTURE_MAX_ANISOTROPY = 34047;
        MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
        MAX_TEXTURE_IMAGE_UNITS = 34930;
        MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
        NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
        COMPRESSED_TEXTURE_FORMATS = 34467;
        NEAREST = 9728;
        LINEAR = 9729;
        LINEAR_MIPMAP_NEAREST = 9985;
        LINEAR_MIPMAP_LINEAR = 9987;
        CLAMP_TO_EDGE = 33071;
        REPEAT = 10497;
        TEXTURE0 = 33984;
        TEXTURE1 = 33985;
        TEXTURE2 = 33986;
        TEXTURE3 = 33987;
        TEXTURE_MIN_FILTER = 10241;
        TEXTURE_MAG_FILTER = 10240;
        TEXTURE_WRAP_S = 10242;
        TEXTURE_WRAP_T = 10243;
        TEXTURE_WRAP_R = 32882;
        TEXTURE_CUBE_MAP = 34067;
        TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
        TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
        TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
        TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
        TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
        TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
        VERTEX_SHADER = 35633;
        FRAGMENT_SHADER = 35632;
        INFO_LOG_LENGTH = 35716;
        SHADER_SOURCE_LENGTH = 35720;
        COMPILE_STATUS = 35713;
        LINK_STATUS = 35714;
        VALIDATE_STATUS = 35715;
        SHADER_TYPE = 35663;
        DELETE_STATUS = 35712;
        FLOAT_VEC2 = 35664;
        FLOAT_VEC3 = 35665;
        FLOAT_VEC4 = 35666;
        FLOAT_MAT2 = 35674;
        FLOAT_MAT3 = 35675;
        FLOAT_MAT4 = 35676;
        INT_VEC2 = 35667;
        INT_VEC3 = 35668;
        INT_VEC4 = 35669;
        BOOL_VEC2 = 35671;
        BOOL_VEC3 = 35672;
        BOOL_VEC4 = 35673;
        SAMPLER_2D = 35678;
        SAMPLER_CUBE = 35680;
        LOW_FLOAT = 36336;
        MEDIUM_FLOAT = 36337;
        HIGH_FLOAT = 36338;
        LOW_INT = 36339;
        MEDIUM_INT = 36340;
        HIGH_INT = 36341;
        CURRENT_VERTEX_ATTRIB = 34342;
        VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
        VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
        VERTEX_ATTRIB_ARRAY_SIZE = 34339;
        VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
        VERTEX_ATTRIB_ARRAY_TYPE = 34341;
        VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
        VERTEX_ATTRIB_ARRAY_POINTER = 34373;
        BLEND = 3042;
        ONE = 1;
        ZERO = 0;
        SRC_ALPHA = 770;
        DST_ALPHA = 772;
        ONE_MINUS_SRC_ALPHA = 771;
        ONE_MINUS_DST_COLOR = 775;
        ONE_MINUS_SRC_COLOR = 769;
        DST_COLOR = 774;
        SRC_COLOR = 768;
        SAMPLE_ALPHA_TO_COVERAGE = 32926;
        SAMPLE_COVERAGE = 32928;
        KEEP = 7680;
        REPLACE = 7681;
        INCR = 7682;
        DECR = 7683;
        INVERT = 5386;
        INCR_WRAP = 34055;
        DECR_WRAP = 34056;
        NEVER = 512;
        ALWAYS = 519;
        EQUAL = 514;
        LESS = 513;
        LEQUAL = 515;
        GREATER = 516;
        GEQUAL = 518;
        NOTEQUAL = 517;
        FUNC_ADD = 32774;
        FUNC_MIN = 32775;
        FUNC_MAX = 32776;
        FUNC_REVERSE_SUBTRACT = 32779;
        FUNC_SUBTRACT = 32778;
        DITHER = 3024;
        CONSTANT_COLOR = 32769;
        CONSTANT_ALPHA = 32771;
        ONE_MINUS_CONSTANT_COLOR = 32770;
        ONE_MINUS_CONSTANT_ALPHA = 32772;
        SRC_ALPHA_SATURATE = 776;
        SCISSOR_TEST = 3089;
        STENCIL_TEST = 2960;
        DEPTH_TEST = 2929;
        DEPTH_WRITEMASK = 2930;
        COLOR_BUFFER_BIT = 16384;
        DEPTH_BUFFER_BIT = 256;
        STENCIL_BUFFER_BIT = 1024;
        FRAMEBUFFER = 36160;
        COLOR_ATTACHMENT0 = 36064;
        COLOR_ATTACHMENT1 = 36065;
        COLOR_ATTACHMENT2 = 36066;
        COLOR_ATTACHMENT3 = 36067;
        RENDERBUFFER = 36161;
        DEPTH_ATTACHMENT = 36096;
        STENCIL_ATTACHMENT = 36128;
        READ_FRAMEBUFFER = 36008;
        DRAW_FRAMEBUFFER = 36009;
        DEPTH24_STENCIL8 = 35056;
        DEPTH_COMPONENT = 6402;
        DEPTH_COMPONENT16 = 33189;
        DEPTH_COMPONENT24 = 33190;
        DEPTH_COMPONENT32 = 33191;
        STENCIL_INDEX = 6401;
        STENCIL_INDEX1 = 36166;
        STENCIL_INDEX4 = 36167;
        STENCIL_INDEX8 = 36168;
        DEPTH_STENCIL = 34041;
        FRAMEBUFFER_COMPLETE = 36053;
        FRAMEBUFFER_UNDEFINED = 33305;
        FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
        FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
        FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
        FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
        FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
        FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        FRAMEBUFFER_UNSUPPORTED = 36061;
        FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
        FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
        FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
        FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
        RENDERBUFFER_WIDTH = 36162;
        RENDERBUFFER_HEIGHT = 36163;
        RENDERBUFFER_RED_SIZE = 36176;
        RENDERBUFFER_GREEN_SIZE = 36177;
        RENDERBUFFER_BLUE_SIZE = 36178;
        RENDERBUFFER_ALPHA_SIZE = 36179;
        RENDERBUFFER_DEPTH_SIZE = 36180;
        RENDERBUFFER_STENCIL_SIZE = 36181;
        RENDERBUFFER_INTERNAL_FORMAT = 36164;
        MULTISAMPLE = 32925;
        LINE_SMOOTH = 2848;
        POLYGON_SMOOTH = 2881;
        SYNC_GPU_COMMANDS_COMPLETE = 37143;
        ALREADY_SIGNALED = 37146;
        CONDITION_SATISFIED = 37148;
    }

    protected class FontOutline
    implements PGL.FontOutline {
        PathIterator iter;

        public FontOutline(char ch, Font font) {
            char[] textArray = new char[]{ch};
            FontRenderContext frc = PLWJGL.this.getFontRenderContext(font);
            GlyphVector gv = font.createGlyphVector(frc, textArray);
            Shape shp = gv.getOutline();
            this.iter = shp.getPathIterator(null);
        }

        public boolean isDone() {
            return this.iter.isDone();
        }

        public int currentSegment(float[] coords) {
            return this.iter.currentSegment(coords);
        }

        public void next() {
            this.iter.next();
        }
    }

    protected class Tessellator
    implements PGL.Tessellator {
        protected PGLUtessellator tess;
        protected PGL.TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(PGL.TessellatorCallback callback) {
            this.callback = callback;
            this.tess = PGLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            PGLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        public void setCallback(int flag) {
            PGLU.gluTessCallback(this.tess, flag, this.gluCallback);
        }

        public void setWindingRule(int rule) {
            PGLU.gluTessProperty(this.tess, 100140, rule);
        }

        public void setProperty(int property, int value) {
            PGLU.gluTessProperty(this.tess, property, value);
        }

        public void beginPolygon() {
            PGLU.gluTessBeginPolygon(this.tess, null);
        }

        public void beginPolygon(Object data) {
            PGLU.gluTessBeginPolygon(this.tess, data);
        }

        public void endPolygon() {
            PGLU.gluTessEndPolygon(this.tess);
        }

        public void beginContour() {
            PGLU.gluTessBeginContour(this.tess);
        }

        public void endContour() {
            PGLU.gluTessEndContour(this.tess);
        }

        public void addVertex(double[] v) {
            PGLU.gluTessVertex(this.tess, v, 0, v);
        }

        public void addVertex(double[] v, int n, Object data) {
            PGLU.gluTessVertex(this.tess, v, n, data);
        }

        protected class GLUCallback
        extends PGLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            @Override
            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            @Override
            public void end() {
                Tessellator.this.callback.end();
            }

            @Override
            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            @Override
            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }
}

