/*
 * Decompiled with CFR 0.152.
 */
package processing.lwjgl;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowContentScaleCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL21C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurface;
import processing.event.Event;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.lwjgl.PGraphicsLWJGL2D;
import processing.lwjgl.PGraphicsLWJGL3D;
import processing.lwjgl.PLWJGL;
import processing.opengl.PGL;

public class PSurfaceLWJGL
implements PSurface {
    private static final boolean DEBUG_GLFW = Boolean.getBoolean("processing.lwjgl.debug");
    private static int initCount;
    private GLDebugMessageCallback debugCallback;
    private PApplet sketch;
    private final PGraphics graphics;
    private final PLWJGL pgl;
    private final BlockingQueue<Runnable> tasks;
    private final int profileGLMajor;
    private final int profileGLMinor;
    private final boolean profileGLES;
    private final boolean profileCore;
    private final boolean profileForward;
    private ScaledSketch scaledSketch;
    private Rectangle requestedSketchSize;
    private Rectangle windowPosSize;
    private Rectangle frameBufferSize;
    private float contentScale;
    private boolean external;
    private long window;
    private long monitor;
    private Rectangle monitorRect;
    private int monitorRefreshRate;
    private Rectangle desktopBounds;
    private volatile boolean threadRunning;
    private float frameRate = 60.0f;
    private int swapInterval;
    private boolean swapIntervalChanged;
    private final List<Callback> callbacks = new ArrayList<Callback>();
    private int mouseX;
    private int mouseY;
    private int pressedMouseButton;
    private int modifiers;
    private static final int MOUSE_CLICK_CANCEL_DIST = 7;
    private int mousePressedX;
    private int mousePressedY;
    private final List<Integer> pressedButtons = new ArrayList<Integer>();

    protected PSurfaceLWJGL(PGraphicsLWJGL2D graphics) {
        this((PGraphics)graphics, (PLWJGL)graphics.pgl);
    }

    protected PSurfaceLWJGL(PGraphicsLWJGL3D graphics) {
        this((PGraphics)graphics, (PLWJGL)graphics.pgl);
    }

    private PSurfaceLWJGL(PGraphics graphics, PLWJGL pgl) {
        this.graphics = graphics;
        this.pgl = pgl;
        this.tasks = new LinkedBlockingQueue<Runnable>();
        int profile = PLWJGL.profile;
        switch (profile) {
            case 1: {
                this.profileGLMajor = 2;
                this.profileGLMinor = 1;
                this.profileGLES = false;
                this.profileCore = false;
                this.profileForward = false;
                break;
            }
            case 2: {
                this.profileGLMajor = 2;
                this.profileGLMinor = 0;
                this.profileGLES = true;
                this.profileCore = false;
                this.profileForward = false;
                break;
            }
            case 4: {
                this.profileGLMajor = 4;
                this.profileGLMinor = 1;
                this.profileGLES = false;
                this.profileCore = true;
                this.profileForward = true;
                break;
            }
            default: {
                this.profileGLMajor = 3;
                this.profileGLMinor = 2;
                this.profileGLES = false;
                this.profileCore = true;
                this.profileForward = true;
            }
        }
    }

    private <T extends Callback> void addCallback(Consumer<T> setter, T callback) {
        this.callbacks.add(callback);
        setter.accept(callback);
    }

    private <T extends Callback> void addWindowCallback(BiConsumer<Long, T> setter, T callback) {
        this.callbacks.add(callback);
        setter.accept(this.window, (Long)callback);
    }

    public void initOffscreen(PApplet sketch) {
        throw new UnsupportedOperationException("This surface does not support offscreen rendering");
    }

    public void initFrame(PApplet sketch) {
        if (!PApplet.mainThread().isMainThread()) {
            throw new IllegalStateException("initFrame not called on main thread");
        }
        this.sketch = sketch;
        if (initCount == 0) {
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)new ErrorHandler());
        }
        if (!GLFW.glfwInit()) {
            PGraphics.showException((String)"Unable to initialize GLFW");
        }
        if (DEBUG_GLFW) {
            System.out.println("GLFW initialized: " + GLFW.glfwGetVersionString());
        }
        this.initDisplay();
        this.initWindow();
        this.initInputListeners();
        ++initCount;
    }

    public Object getNative() {
        return this.window;
    }

    public void setTitle(String title) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setTitle(title));
            return;
        }
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title);
    }

    public void setVisible(boolean visible) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setVisible(visible));
            return;
        }
        if (visible) {
            GLFW.glfwShowWindow((long)this.window);
        } else {
            GLFW.glfwHideWindow((long)this.window);
        }
        GLFW.glfwPollEvents();
    }

    public void setResizable(boolean resizable) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setResizable(resizable));
            return;
        }
        int value = resizable ? 1 : 0;
        GLFW.glfwSetWindowAttrib((long)this.window, (int)131075, (int)value);
    }

    public void setAlwaysOnTop(boolean always) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setAlwaysOnTop(always));
            return;
        }
        int value = always ? 1 : 0;
        GLFW.glfwSetWindowAttrib((long)this.window, (int)131079, (int)value);
    }

    public void setIcon(PImage icon) {
    }

    private void initDisplay() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pX = stack.mallocInt(1);
            IntBuffer pY = stack.mallocInt(1);
            PointerBuffer monitorList = GLFW.glfwGetMonitors();
            if (monitorList == null || monitorList.limit() == 0) {
                PGraphics.showException((String)"No monitors found");
            }
            if (DEBUG_GLFW) {
                FloatBuffer scaleX = stack.mallocFloat(1);
                FloatBuffer scaleY = stack.mallocFloat(1);
                for (int i = 0; i < monitorList.limit(); ++i) {
                    long m = monitorList.get(i);
                    String name = GLFW.glfwGetMonitorName((long)m);
                    GLFW.glfwGetMonitorPos((long)m, (IntBuffer)pX, (IntBuffer)pY);
                    GLFW.glfwGetMonitorContentScale((long)m, (FloatBuffer)scaleX, (FloatBuffer)scaleY);
                    GLFWVidMode mode = GLFW.glfwGetVideoMode((long)m);
                    int w = 0;
                    int h = 0;
                    int refresh = 0;
                    if (mode != null) {
                        w = mode.width();
                        h = mode.height();
                        refresh = mode.refreshRate();
                    }
                    System.out.format("Display %d is %s { size: %dx%d, refresh: %d hz, pos: (%d,%d), scale: %.02fx%.02f }%n", i + 1, name, w, h, refresh, pX.get(0), pY.get(0), Float.valueOf(scaleX.get(0)), Float.valueOf(scaleY.get(0)));
                }
            }
            long monitor = monitorList.get(0);
            int displayNum = this.sketch.sketchDisplay();
            if (displayNum == 0) {
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int i = 0; i < monitorList.limit(); ++i) {
                    long m = monitorList.get(i);
                    GLFW.glfwGetMonitorPos((long)m, (IntBuffer)pX, (IntBuffer)pY);
                    GLFWVidMode mode = GLFW.glfwGetVideoMode((long)m);
                    if (mode == null) continue;
                    minX = Math.min(minX, pX.get(0));
                    minY = Math.min(minY, pY.get(0));
                    maxX = Math.max(maxX, pX.get(0) + mode.width());
                    maxY = Math.max(maxY, pY.get(0) + mode.height());
                }
                this.desktopBounds = new Rectangle(minX, minY, maxX - minX, maxY - minY);
                if (DEBUG_GLFW) {
                    System.out.println("GLFW screen area is " + this.desktopBounds.toString());
                }
            } else if (displayNum > 0) {
                if (displayNum <= monitorList.limit()) {
                    monitor = monitorList.get(displayNum - 1);
                } else {
                    System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                    for (int i = 0; i < monitorList.limit(); ++i) {
                        long m = monitorList.get(i);
                        String name = GLFW.glfwGetMonitorName((long)m);
                        GLFW.glfwGetMonitorPos((long)m, (IntBuffer)pX, (IntBuffer)pY);
                        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)m);
                        int w = 0;
                        int h = 0;
                        if (mode != null) {
                            w = mode.width();
                            h = mode.height();
                        }
                        System.err.format("Display %d is %s { size: %dx%d, pos: %d,%d }%n", i + 1, name, w, h, pX.get(0), pY.get(0));
                    }
                }
            }
            GLFW.glfwGetMonitorPos((long)monitor, (IntBuffer)pX, (IntBuffer)pY);
            GLFWVidMode mode = GLFW.glfwGetVideoMode((long)monitor);
            if (mode == null) {
                PGraphics.showException((String)"Could not retrieve monitor resolution");
            }
            this.monitorRect = new Rectangle(pX.get(0), pY.get(0), mode.width(), mode.height());
            this.monitorRefreshRate = mode.refreshRate();
            if (DEBUG_GLFW) {
                System.out.println("GLFW monitor rect: " + this.monitorRect);
                System.out.println("GLFW monitor refresh rate: " + this.monitorRefreshRate);
            }
            this.monitor = monitor;
        }
    }

    private void initWindow() {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131075, (int)0);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131078, (int)0);
        if (this.profileGLES) {
            GLFW.glfwWindowHint((int)139265, (int)196610);
        } else {
            GLFW.glfwWindowHint((int)139265, (int)196609);
        }
        GLFW.glfwWindowHint((int)139266, (int)this.profileGLMajor);
        GLFW.glfwWindowHint((int)139267, (int)this.profileGLMinor);
        if (this.profileCore) {
            GLFW.glfwWindowHint((int)139272, (int)204801);
        } else {
            GLFW.glfwWindowHint((int)139272, (int)0);
        }
        if (this.profileForward) {
            GLFW.glfwWindowHint((int)139270, (int)1);
        }
        GLFW.glfwWindowHint((int)135172, (int)PGL.REQUESTED_ALPHA_BITS);
        GLFW.glfwWindowHint((int)135173, (int)PGL.REQUESTED_DEPTH_BITS);
        GLFW.glfwWindowHint((int)135174, (int)PGL.REQUESTED_STENCIL_BITS);
        this.pgl.reqNumSamples = PGL.smoothToSamples((int)this.graphics.smooth);
        GLFW.glfwWindowHint((int)135181, (int)this.pgl.reqNumSamples);
        if (this.sketch.sketchDisplay() == 0) {
            PApplet.hideMenuBar();
            GLFW.glfwWindowHint((int)131077, (int)0);
            this.window = GLFW.glfwCreateWindow((int)this.desktopBounds.w, (int)this.desktopBounds.h, (CharSequence)"Sketch", (long)0L, (long)0L);
            GLFW.glfwSetWindowPos((long)this.window, (int)this.desktopBounds.x, (int)this.desktopBounds.y);
        } else if (this.sketch.sketchFullScreen()) {
            PApplet.hideMenuBar();
            GLFWVidMode mode = GLFW.glfwGetVideoMode((long)this.monitor);
            if (mode == null) {
                PGraphics.showException((String)"Could not retrieve monitor resolution");
            }
            GLFW.glfwWindowHint((int)135169, (int)mode.redBits());
            GLFW.glfwWindowHint((int)135170, (int)mode.greenBits());
            GLFW.glfwWindowHint((int)135171, (int)mode.blueBits());
            GLFW.glfwWindowHint((int)135183, (int)mode.refreshRate());
            this.window = GLFW.glfwCreateWindow((int)mode.width(), (int)mode.height(), (CharSequence)"Sketch", (long)this.monitor, (long)0L);
        } else {
            this.requestedSketchSize = new Rectangle();
            this.requestedSketchSize.w = this.sketch.sketchWidth();
            this.requestedSketchSize.h = this.sketch.sketchHeight();
            this.window = GLFW.glfwCreateWindow((int)100, (int)100, (CharSequence)"Sketch", (long)0L, (long)0L);
            GLFW.glfwSetWindowPos((long)this.window, (int)(this.monitorRect.x + (this.monitorRect.w + 50) / 2), (int)(this.monitorRect.y + (this.monitorRect.h + 50) / 2));
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h = stack.mallocInt(1);
            FloatBuffer scale = stack.mallocFloat(1);
            GLFW.glfwGetWindowContentScale((long)this.window, (FloatBuffer)scale, null);
            this.contentScale = scale.get(0);
            if (DEBUG_GLFW) {
                System.out.println("GLFW window content scale: " + this.contentScale);
            }
            this.scaledSketch = new ScaledSketch(this.sketch, this.graphics, this.pgl, this.contentScale);
            if (!this.sketch.sketchFullScreen() && this.sketch.sketchDisplay() != 0) {
                int windowWidth = this.scaledSketch.sketchToWindowUnits(this.sketch.sketchWidth());
                int windowHeight = this.scaledSketch.sketchToWindowUnits(this.sketch.sketchHeight());
                GLFW.glfwSetWindowSize((long)this.window, (int)windowWidth, (int)windowHeight);
            }
            GLFW.glfwGetFramebufferSize((long)this.window, (IntBuffer)w, (IntBuffer)h);
            int width2 = w.get(0);
            int height2 = h.get(0);
            this.frameBufferSize = new Rectangle();
            this.frameBufferSize.w = width2;
            this.frameBufferSize.h = height2;
            if (DEBUG_GLFW) {
                System.out.println("GLFW framebuffer size: " + width2 + " " + height2);
            }
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)w, (IntBuffer)h);
            this.windowPosSize = new Rectangle();
            this.windowPosSize.w = w.get(0);
            this.windowPosSize.h = h.get(0);
            if (DEBUG_GLFW) {
                System.out.println("GLFW window size: " + this.windowPosSize.w + " " + this.windowPosSize.h);
            }
            this.scaledSketch.updateSketchSize(this.contentScale, this.frameBufferSize.w, this.frameBufferSize.h);
            this.setFrameRate(this.monitorRefreshRate);
        }
        this.addWindowCallback(GLFW::glfwSetFramebufferSizeCallback, GLFWFramebufferSizeCallback.create((window1, width, height) -> {
            if (width != 0 && height != 0 && !this.pgl.presentMode()) {
                this.frameBufferSize.w = width;
                this.frameBufferSize.h = height;
                this.tasks.add(() -> this.scaledSketch.updateSketchSize(this.contentScale, this.frameBufferSize.w, this.frameBufferSize.h));
            }
            if (DEBUG_GLFW) {
                System.out.println("GLFW framebuffer size changed: " + width + " " + height);
            }
        }));
        this.addWindowCallback(GLFW::glfwSetWindowPosCallback, GLFWWindowPosCallback.create((window1, xpos, ypos) -> {
            this.windowPosSize.x = xpos;
            this.windowPosSize.y = ypos;
            if (this.external) {
                this.tasks.add(() -> this.sketch.frameMoved(xpos, ypos));
            }
        }));
        this.addWindowCallback(GLFW::glfwSetWindowSizeCallback, GLFWWindowSizeCallback.create((window1, width, height) -> {
            if (width != 0 && height != 0) {
                this.windowPosSize.w = width;
                this.windowPosSize.h = height;
            }
            if (DEBUG_GLFW) {
                System.out.println("GLFW window size changed: " + width + " " + height);
            }
        }));
        this.addWindowCallback(GLFW::glfwSetWindowContentScaleCallback, GLFWWindowContentScaleCallback.create((window1, xscale, yscale) -> {
            if (this.contentScale != xscale && !this.pgl.presentMode()) {
                this.contentScale = xscale;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer w = stack.mallocInt(1);
                    IntBuffer h = stack.mallocInt(1);
                    GLFW.glfwGetFramebufferSize((long)this.window, (IntBuffer)w, (IntBuffer)h);
                    this.frameBufferSize.w = w.get(0);
                    this.frameBufferSize.h = h.get(0);
                }
                this.tasks.add(() -> this.scaledSketch.updateSketchSize(this.contentScale, this.frameBufferSize.w, this.frameBufferSize.h));
            }
            if (DEBUG_GLFW) {
                System.out.println("GLFW window scale changed: " + this.contentScale);
            }
        }));
        this.addWindowCallback(GLFW::glfwSetWindowCloseCallback, GLFWWindowCloseCallback.create(window1 -> {
            GLFW.glfwSetWindowShouldClose((long)window1, (boolean)false);
            this.tasks.add(() -> this.sketch.exit());
        }));
        this.addWindowCallback(GLFW::glfwSetWindowFocusCallback, GLFWWindowFocusCallback.create((window1, focused) -> {
            this.tasks.add(() -> {
                this.sketch.focused = focused;
                if (focused) {
                    this.sketch.focusGained();
                } else {
                    this.sketch.focusLost();
                }
            });
            if (DEBUG_GLFW) {
                System.out.println("GLFW window focus changed: " + focused);
            }
        }));
        this.addWindowCallback(GLFW::glfwSetWindowRefreshCallback, GLFWWindowRefreshCallback.create(window1 -> {
            this.tasks.add(() -> {
                if (!this.sketch.isLooping()) {
                    this.sketch.redraw();
                }
                if (this.sketch.frameCount > 0) {
                    this.handleDraw();
                }
            });
            if (DEBUG_GLFW) {
                System.out.println("GLFW window redraw notification");
            }
        }));
    }

    private int convertModifierBits(int glfwBits) {
        return glfwBits & 1 | glfwBits & 2 | glfwBits & 4 | glfwBits & 8;
    }

    private char convertKey(int glfwKey, boolean uppercase) {
        switch (glfwKey) {
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 340: 
            case 341: 
            case 342: 
            case 344: 
            case 345: 
            case 346: {
                return '\uffff';
            }
            case 259: {
                return '\b';
            }
            case 258: {
                return '\t';
            }
            case 257: 
            case 335: {
                return '\n';
            }
            case 256: {
                return '\u001b';
            }
            case 261: {
                return '\u007f';
            }
            case 334: {
                return '+';
            }
            case 333: {
                return '-';
            }
            case 331: {
                return '/';
            }
            case 332: {
                return '*';
            }
            case 336: {
                return '=';
            }
            case 330: {
                return '.';
            }
        }
        if (glfwKey >= 32 && glfwKey <= 96) {
            if (!uppercase && glfwKey >= 65 && glfwKey <= 90) {
                return (char)(glfwKey + 32);
            }
            return (char)glfwKey;
        }
        if (glfwKey >= 320 && glfwKey <= 329) {
            int offset = glfwKey - 320;
            return (char)(48 + offset);
        }
        return '\uffff';
    }

    private int convertKeyCode(int glfwKey) {
        switch (glfwKey) {
            case 265: {
                return 38;
            }
            case 264: {
                return 40;
            }
            case 263: {
                return 37;
            }
            case 262: {
                return 39;
            }
            case 342: 
            case 346: {
                return 18;
            }
            case 341: 
            case 345: {
                return 17;
            }
            case 340: 
            case 344: {
                return 16;
            }
        }
        return glfwKey;
    }

    private int convertMouseButton(int glfwButton) {
        switch (glfwButton) {
            case 0: {
                return 37;
            }
            case 1: {
                return 39;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private void updateMouseButtonCache(int button, boolean pressed) {
        if (pressed) {
            this.pressedButtons.add(button);
        } else {
            int index = this.pressedButtons.lastIndexOf(button);
            if (index >= 0) {
                this.pressedButtons.remove(index);
            }
        }
        if (pressed) {
            this.pressedMouseButton = button;
        } else if (this.pressedMouseButton == button) {
            this.pressedMouseButton = this.pressedButtons.isEmpty() ? 0 : this.pressedButtons.get(this.pressedButtons.size() - 1);
        }
    }

    private void initInputListeners() {
        this.addWindowCallback(GLFW::glfwSetMouseButtonCallback, GLFWMouseButtonCallback.create((window1, button, action, mods) -> {
            this.modifiers = this.convertModifierBits(mods);
            button = this.convertMouseButton(button);
            long nowMs = System.currentTimeMillis();
            switch (action) {
                case 1: {
                    this.updateMouseButtonCache(button, true);
                    this.scaledSketch.postMouseEvent(nowMs, 1, this.modifiers, this.mouseX, this.mouseY, button, 0);
                    this.mousePressedX = this.mouseX;
                    this.mousePressedY = this.mouseY;
                    break;
                }
                case 0: {
                    int y;
                    int x;
                    if (this.pgl.presentMode() && this.pgl.insideStopButton(x = this.scaledSketch.windowToSketchUnits(this.mouseX), y = this.scaledSketch.windowToSketchUnits(this.mouseY - this.monitorRect.h))) {
                        this.sketch.exit();
                    }
                    this.updateMouseButtonCache(button, false);
                    this.scaledSketch.postMouseEvent(nowMs, 2, this.modifiers, this.mouseX, this.mouseY, button, 0);
                    int dragDist = PApplet.max((int)PApplet.abs((int)(this.mouseX - this.mousePressedX)), (int)PApplet.abs((int)(this.mouseY - this.mousePressedY)));
                    if (dragDist > 7) break;
                    this.scaledSketch.postMouseEvent(nowMs, 3, this.modifiers, this.mouseX, this.mouseY, button, 0);
                }
            }
        }));
        this.addWindowCallback(GLFW::glfwSetCursorPosCallback, GLFWCursorPosCallback.create((window1, xpos, ypos) -> {
            this.mouseX = (int)xpos;
            this.mouseY = (int)ypos;
            int action = this.pressedMouseButton == 0 ? 5 : 4;
            long nowMs = System.currentTimeMillis();
            this.scaledSketch.postMouseEvent(nowMs, action, this.modifiers, this.mouseX, this.mouseY, this.pressedMouseButton, 0);
        }));
        this.addWindowCallback(GLFW::glfwSetScrollCallback, GLFWScrollCallback.create((window1, xoffset, yoffset) -> {
            int count = (int)(-yoffset);
            long nowMs = System.currentTimeMillis();
            this.scaledSketch.postMouseEvent(nowMs, 8, this.modifiers, this.mouseX, this.mouseY, this.pressedMouseButton, count);
        }));
        this.addWindowCallback(GLFW::glfwSetCursorEnterCallback, GLFWCursorEnterCallback.create((window1, entered) -> {
            int action = entered ? 6 : 7;
            long nowMs = System.currentTimeMillis();
            this.scaledSketch.postMouseEvent(nowMs, action, this.modifiers, this.mouseX, this.mouseY, this.pressedMouseButton, 0);
        }));
        GLFW.glfwSetInputMode((long)this.window, (int)208900, (int)1);
        this.addWindowCallback(GLFW::glfwSetKeyCallback, GLFWKeyCallback.create((window1, key, scancode, action, mods) -> {
            boolean repeat;
            this.modifiers = this.convertModifierBits(mods);
            boolean bl = repeat = action == 2;
            if (action == 1 || action == 2) {
                action = 1;
            } else if (action == 0) {
                action = 2;
            }
            boolean uppercase = (mods & 1) != 0 ^ (mods & 0x10) != 0;
            char pKey = this.convertKey(key, uppercase);
            int pKeyCode = this.convertKeyCode(key);
            long nowMs = System.currentTimeMillis();
            this.sketch.postEvent((Event)new KeyEvent(null, nowMs, action, this.modifiers, pKey, pKeyCode, repeat));
            if (action == 1 && key == 10) {
                this.sketch.postEvent((Event)new KeyEvent(null, nowMs, 3, this.modifiers, pKey, -1, false));
            }
        }));
        this.addWindowCallback(GLFW::glfwSetCharCallback, GLFWCharCallback.create((window1, codepoint) -> {
            long nowMs = System.currentTimeMillis();
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                codepoint = codepoint & 0xFF000000 | codepoint & 0xFF0000 | codepoint & 0xFF00 | codepoint & 0xFF;
            }
            if ((codepoint & 0xFFFF0000) == 0) {
                this.sketch.postEvent((Event)new KeyEvent(null, nowMs, 3, this.modifiers, (char)codepoint, -1, false));
            } else {
                int high = 55296 + ((codepoint -= 65536) >> 22 & 0x3FF);
                int low = 56320 + (codepoint & 0x3FF);
                this.sketch.postEvent((Event)new KeyEvent(null, nowMs, 3, this.modifiers, (char)high, -1, false));
                this.sketch.postEvent((Event)new KeyEvent(null, nowMs, 3, this.modifiers, (char)low, -1, false));
            }
        }));
    }

    public void placeWindow(int[] location, int[] editorLocation) {
        int frmW;
        int frmT;
        int frmL;
        int cliH;
        int cliW;
        if (this.sketch.sketchFullScreen()) {
            return;
        }
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.placeWindow(location, editorLocation));
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer cliWBuf = stack.mallocInt(1);
            IntBuffer cliHBuf = stack.mallocInt(1);
            IntBuffer frmLBuf = stack.mallocInt(1);
            IntBuffer frmTBuf = stack.mallocInt(1);
            IntBuffer frmRBuf = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)cliWBuf, (IntBuffer)cliHBuf);
            GLFW.glfwGetWindowFrameSize((long)this.window, (IntBuffer)frmLBuf, (IntBuffer)frmTBuf, (IntBuffer)frmRBuf, null);
            cliW = cliWBuf.get(0);
            cliH = cliHBuf.get(0);
            frmL = frmLBuf.get(0);
            frmT = frmTBuf.get(0);
            frmW = cliWBuf.get(0) + frmLBuf.get(0) + frmRBuf.get(0);
        }
        if (location != null) {
            GLFW.glfwSetWindowPos((long)this.window, (int)(location[0] + frmL), (int)(location[1] + frmT));
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if (locationX - frmW > 10) {
                GLFW.glfwSetWindowPos((long)this.window, (int)(locationX - frmW + frmL), (int)(locationY + frmT));
            } else {
                GLFW.glfwSetWindowPos((long)this.window, (int)(this.monitorRect.x + (this.monitorRect.w - cliW) / 2), (int)(this.monitorRect.y + (this.monitorRect.h - cliH) / 2));
            }
        } else {
            GLFW.glfwSetWindowPos((long)this.window, (int)(this.monitorRect.x + (this.monitorRect.w - cliW) / 2), (int)(this.monitorRect.y + (this.monitorRect.h - cliH) / 2));
        }
    }

    public void placePresent(int stopColor) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.placePresent(stopColor));
            return;
        }
        int wuSketchWidth = this.scaledSketch.sketchToWindowUnits(this.sketch.sketchWidth());
        int wuSketchHeight = this.scaledSketch.sketchToWindowUnits(this.sketch.sketchHeight());
        float wuX = this.monitorRect.w - wuSketchWidth;
        float wuY = this.monitorRect.h - wuSketchHeight;
        float x = (float)this.scaledSketch.windowToSketchUnits(wuX) * 0.5f;
        float y = (float)this.scaledSketch.windowToSketchUnits(wuY) * 0.5f;
        this.pgl.initPresentMode(x, y, stopColor);
        GLFW.glfwSetWindowMonitor((long)this.window, (long)this.monitor, (int)0, (int)0, (int)this.monitorRect.w, (int)this.monitorRect.h, (int)-1);
    }

    public void setupExternalMessages() {
        this.external = true;
    }

    public void setLocation(int x, int y) {
        if (this.sketch.sketchDisplay() == 0) {
            return;
        }
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setLocation(x, y));
            return;
        }
        int sx = this.scaledSketch.sketchToWindowUnits(x);
        int sy = this.scaledSketch.sketchToWindowUnits(y);
        GLFW.glfwSetWindowPos((long)this.window, (int)sx, (int)sy);
    }

    public void setSize(int width, int height) {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setSize(width, height));
            return;
        }
        int sw = this.scaledSketch.sketchToWindowUnits(width);
        int sy = this.scaledSketch.sketchToWindowUnits(height);
        GLFW.glfwSetWindowSize((long)this.window, (int)sw, (int)sy);
    }

    public void setFrameRate(float fps) {
        if (fps < 1.0f) {
            PGraphics.showWarning((String)"The OpenGL renderer cannot have a frame rate lower than 1.\nYour sketch will run at 1 frame per second.");
            fps = 1.0f;
        }
        this.frameRate = fps;
        this.swapInterval = Math.min(1, (int)((float)this.monitorRefreshRate / fps));
        this.swapIntervalChanged = true;
    }

    public void setCursor(int kind) {
        int k;
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.setCursor(kind));
            return;
        }
        switch (kind) {
            case 0: {
                k = 221185;
                break;
            }
            case 1: {
                k = 221187;
                break;
            }
            case 12: {
                k = 221188;
                break;
            }
            case 2: {
                k = 221186;
                break;
            }
            case 13: {
                k = 221189;
                break;
            }
            case 3: {
                k = 221185;
                PGraphics.showWarning((String)"This renderer does not support WAIT cursor.");
                break;
            }
            default: {
                PGraphics.showWarning((String)"Unknown cursor kind.");
                return;
            }
        }
        GLFW.glfwCreateStandardCursor((int)k);
        GLFW.glfwSetCursor((long)this.window, (long)k);
    }

    public void setCursor(PImage image, int hotspotX, int hotspotY) {
    }

    public void showCursor() {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.showCursor());
            return;
        }
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212993);
    }

    public void hideCursor() {
        if (!PApplet.mainThread().isMainThread()) {
            PApplet.mainThread().runLater(() -> this.hideCursor());
            return;
        }
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)212994);
    }

    private void setupDebugOpenGLCallback() {
        if (GL.getCapabilities().GL_KHR_debug) {
            GL21C.glEnable((int)37600);
            GL21C.glEnable((int)33346);
            this.debugCallback = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> new Exception(MemoryUtil.memUTF8((long)message)).printStackTrace());
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)this.debugCallback, (long)0L);
        }
    }

    public void startThread() {
        if (this.threadRunning) {
            throw new IllegalStateException();
        }
        new Thread(this::handleRun).start();
    }

    private void handleRun() {
        this.threadRunning = true;
        try {
            Sync sync = new Sync();
            sync.initialise();
            GLFW.glfwMakeContextCurrent((long)this.window);
            GL.createCapabilities();
            this.pgl.setThread(Thread.currentThread());
            if (DEBUG_GLFW) {
                this.setupDebugOpenGLCallback();
            }
            GL31C.glBindVertexArray((int)GL31C.glGenVertexArrays());
            while (this.threadRunning) {
                if (this.sketch.frameCount > 0 && this.swapIntervalChanged) {
                    GLFW.glfwSwapInterval((int)this.swapInterval);
                    this.swapIntervalChanged = false;
                }
                sync.sync(this.frameRate);
                Runnable t = (Runnable)this.tasks.poll();
                while (t != null) {
                    t.run();
                    t = (Runnable)this.tasks.poll();
                }
                this.handleDraw();
                PApplet.mainThread().runLater(GLFW::glfwPollEvents);
            }
            GL31C.glBindVertexArray((int)0);
        }
        catch (Throwable ex) {
            this.threadRunning = false;
            System.getLogger(PSurfaceLWJGL.class.getName()).log(System.Logger.Level.ERROR, "Uncaught exception in rendering thread", ex);
        }
        PApplet.mainThread().runLater(() -> {
            Callbacks.glfwFreeCallbacks((long)this.window);
            this.callbacks.clear();
            GLFW.glfwDestroyWindow((long)this.window);
            GLFW.glfwPollEvents();
            if (--initCount <= 0) {
                GLFW.glfwTerminate();
                GLFWErrorCallback err = GLFW.glfwSetErrorCallback(null);
                if (err != null) {
                    err.free();
                }
                initCount = 0;
            }
            this.sketch.exitActual();
        });
    }

    private void handleDraw() {
        if (this.sketch.frameCount == 0 && this.requestedSketchSize != null && (this.windowPosSize.w < this.requestedSketchSize.w || this.windowPosSize.h < this.requestedSketchSize.h)) {
            PGraphics.showWarning((String)"The sketch has been automatically resized to fit the screen resolution");
        }
        if (!this.sketch.finished) {
            int pframeCount = this.sketch.frameCount;
            this.sketch.handleDraw();
            if (pframeCount != this.sketch.frameCount && !this.sketch.finished) {
                GLFW.glfwSwapBuffers((long)this.window);
            }
        }
        if (this.sketch.exitCalled()) {
            this.sketch.dispose();
        }
    }

    public void pauseThread() {
    }

    public void resumeThread() {
    }

    public boolean stopThread() {
        boolean ret = this.threadRunning;
        this.threadRunning = false;
        return ret;
    }

    public boolean isStopped() {
        return !this.threadRunning;
    }

    private static class ErrorHandler
    implements GLFWErrorCallbackI {
        private ErrorHandler() {
        }

        public void invoke(int error, long description) {
            String message = MemoryUtil.memUTF8((long)description);
            PGraphics.showWarning((String)("GLFW error " + error + ": " + message));
        }
    }

    private static class Sync {
        private static final long NANOS_IN_SECOND = 1000000000L;
        private long nextFrame = 0L;
        private boolean initialised = false;
        private RunningAvg sleepDurations = new RunningAvg(10);
        private RunningAvg yieldDurations = new RunningAvg(10);

        private Sync() {
        }

        public void sync(float fps) {
            if (fps <= 0.0f) {
                return;
            }
            if (!this.initialised) {
                this.initialise();
            }
            try {
                long t1;
                long t0 = Sync.getTime();
                while (this.nextFrame - t0 > this.sleepDurations.avg()) {
                    Thread.sleep(1L);
                    t1 = Sync.getTime();
                    this.sleepDurations.add(t1 - t0);
                    t0 = t1;
                }
                this.sleepDurations.dampenForLowResTicker();
                t0 = Sync.getTime();
                while (this.nextFrame - t0 > this.yieldDurations.avg()) {
                    Thread.yield();
                    t1 = Sync.getTime();
                    this.yieldDurations.add(t1 - t0);
                    t0 = t1;
                }
            }
            catch (InterruptedException t0) {
                // empty catch block
            }
            this.nextFrame += (long)(1.0E9 / (double)fps);
            long now = Sync.getTime();
            long remaining = this.nextFrame - now;
            this.nextFrame = now + Math.max(0L, remaining);
        }

        private void initialise() {
            this.initialised = true;
            this.sleepDurations.init(1000000L);
            this.yieldDurations.init((int)((double)(-(Sync.getTime() - Sync.getTime())) * 1.333));
            this.nextFrame = Sync.getTime();
        }

        private static long getTime() {
            long value = GLFW.glfwGetTimerValue();
            long freq = GLFW.glfwGetTimerFrequency();
            long seconds = value / freq;
            long remainder = value % freq;
            return seconds * 1000000000L + remainder * 1000000000L / freq;
        }

        private static class RunningAvg {
            private final long[] slots;
            private int offset;
            private static final long DAMPEN_THRESHOLD = 10000000L;
            private static final float DAMPEN_FACTOR = 0.9f;

            public RunningAvg(int slotCount) {
                this.slots = new long[slotCount];
                this.offset = 0;
            }

            public void init(long value) {
                while (this.offset < this.slots.length) {
                    this.slots[this.offset++] = value;
                }
            }

            public void add(long value) {
                this.slots[this.offset++ % this.slots.length] = value;
                this.offset %= this.slots.length;
            }

            public long avg() {
                long sum = 0L;
                for (int i = 0; i < this.slots.length; ++i) {
                    sum += this.slots[i];
                }
                return sum / (long)this.slots.length;
            }

            public void dampenForLowResTicker() {
                if (this.avg() > 10000000L) {
                    int i = 0;
                    while (i < this.slots.length) {
                        int n = i++;
                        this.slots[n] = (long)((float)this.slots[n] * 0.9f);
                    }
                }
            }
        }
    }

    private static class Rectangle {
        int x;
        int y;
        int w;
        int h;

        Rectangle() {
        }

        Rectangle(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public String toString() {
            return "Rectangle{x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + "}";
        }
    }

    private static class ScaledSketch {
        private final PApplet sketch;
        private final PGraphics graphics;
        private final PGL pgl;
        private final boolean isSketchDensityAware;
        private int sketchDensity;
        private final boolean hasWindowUnitsEqualToPixels;
        private float windowUnitsToPixelsFactor;

        ScaledSketch(PApplet sketch, PGraphics graphics, PLWJGL pgl, float contentScale) {
            this.sketch = sketch;
            this.graphics = graphics;
            this.pgl = pgl;
            this.isSketchDensityAware = sketch.sketchPixelDensity() > 1;
            String version = GLFW.glfwGetVersionString();
            String[] parts = version.split(" ", 3);
            boolean isWin32orX11 = false;
            if (parts.length >= 2) {
                isWin32orX11 = parts[1].equalsIgnoreCase("Win32") || parts[1].equalsIgnoreCase("X11");
            }
            this.hasWindowUnitsEqualToPixels = isWin32orX11;
            this.windowUnitsToPixelsFactor = this.calculateNewWindowUnitsToPixelsFactor(contentScale);
            this.sketchDensity = this.calculateNewSketchDensity(contentScale);
        }

        private float calculateNewWindowUnitsToPixelsFactor(float contentScale) {
            return this.hasWindowUnitsEqualToPixels ? 1.0f : contentScale;
        }

        private int calculateNewSketchDensity(float contentScale) {
            if (!this.isSketchDensityAware) {
                return 1;
            }
            int contentScaleInt = PApplet.floor((float)contentScale);
            return PApplet.max((int)contentScaleInt, (int)1);
        }

        void updateSketchSize(float contentScale, int pixelWidth, int pixelHeight) {
            this.windowUnitsToPixelsFactor = this.calculateNewWindowUnitsToPixelsFactor(contentScale);
            this.sketchDensity = this.calculateNewSketchDensity(contentScale);
            int sketchWidth = (pixelWidth + this.sketchDensity - 1) / this.sketchDensity;
            int sketchHeight = (pixelHeight + this.sketchDensity - 1) / this.sketchDensity;
            this.pgl.resetFBOLayer();
            this.sketch.pixelDensity = this.sketchDensity;
            this.sketch.setSize(sketchWidth, sketchHeight);
            this.graphics.pixelDensity = this.sketchDensity;
            this.graphics.setSize(sketchWidth, sketchHeight);
        }

        int sketchToWindowUnits(int sketchUnits) {
            return PApplet.floor((float)((float)(sketchUnits * this.sketchDensity) / this.windowUnitsToPixelsFactor));
        }

        int windowToSketchUnits(float windowUnits) {
            return PApplet.floor((float)(windowUnits * this.windowUnitsToPixelsFactor / (float)this.sketchDensity));
        }

        void postMouseEvent(long millis, int action, int modifiers, int windowX, int windowY, int button, int count) {
            int sketchX = this.windowToSketchUnits(windowX);
            int sketchY = this.windowToSketchUnits(windowY);
            if (this.pgl.presentMode()) {
                sketchX = (int)((float)sketchX - this.pgl.presentX);
                sketchY = (int)((float)sketchY - this.pgl.presentY);
                if (sketchX < 0 || sketchX >= this.sketch.sketchWidth() || sketchY < 0 || sketchY >= this.sketch.sketchHeight()) {
                    return;
                }
            }
            MouseEvent event = new MouseEvent(null, millis, action, modifiers, sketchX, sketchY, button, count);
            this.sketch.postEvent((Event)event);
        }
    }
}

