/*
 * Decompiled with CFR 0.152.
 */
package org.prefixcommons.trie;

import java.util.HashMap;
import org.prefixcommons.trie.TrieNode;

public class Trie {
    private final TrieNode root = new TrieNode('\u0000');

    public void insert(String word) {
        int length = word.length();
        TrieNode crawl = this.root;
        for (int level = 0; level < length; ++level) {
            char ch;
            HashMap<Character, TrieNode> child = crawl.getChildren();
            if (child.containsKey(Character.valueOf(ch = word.charAt(level)))) {
                crawl = child.get(Character.valueOf(ch));
                continue;
            }
            TrieNode temp = new TrieNode(ch);
            child.put(Character.valueOf(ch), temp);
            crawl = temp;
        }
        crawl.setIsLeaf(true);
    }

    public String getMatchingPrefix(String input) {
        String result = "";
        int length = input.length();
        TrieNode crawl = this.root;
        int prevMatch = 0;
        for (int level = 0; level < length; ++level) {
            char ch = input.charAt(level);
            HashMap<Character, TrieNode> child = crawl.getChildren();
            if (!child.containsKey(Character.valueOf(ch))) break;
            result = result + ch;
            crawl = child.get(Character.valueOf(ch));
            if (!crawl.isLeaf()) continue;
            prevMatch = level + 1;
        }
        if (!crawl.isLeaf()) {
            return result.substring(0, prevMatch);
        }
        return result;
    }
}

