/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.postnet;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BaselineAlignment;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import org.krysalis.barcode4j.impl.postnet.POSTNETLogicHandler;
import org.krysalis.barcode4j.impl.postnet.POSTNETLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class POSTNETBean
extends HeightVariableBarcodeBean {
    static final double DEFAULT_MODULE_WIDTH = (double)0.02f;
    static final double DEFAULT_TALL_BAR_HEIGHT = 0.125;
    static final double DEFAULT_SHORT_BAR_HEIGHT = (double)0.05f;
    static final double DEFAULT_HORZ_QUIET_ZONE_INCH = 0.125;
    static final double DEFAULT_VERT_QUIET_ZONE_INCH = 0.04;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth;
    private BaselineAlignment baselinePosition = BaselineAlignment.ALIGN_BOTTOM;
    private double shortBarHeight = UnitConv.in2mm(0.05f);
    private boolean displayChecksum = false;
    private Double quietZoneVertical;

    public POSTNETBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
        this.intercharGapWidth = this.moduleWidth = UnitConv.in2mm(0.02f);
        this.setQuietZone(UnitConv.in2mm(0.125));
        this.setVerticalQuietZone(UnitConv.in2mm(0.04));
        this.setBarHeight(UnitConv.in2mm(0.125));
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double width) {
        this.intercharGapWidth = width;
    }

    public double getShortBarHeight() {
        return this.shortBarHeight;
    }

    public void setShortBarHeight(double height) {
        this.shortBarHeight = height;
    }

    @Override
    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only width 1 allowed");
    }

    @Override
    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    @Override
    public void setVerticalQuietZone(double height) {
        this.quietZoneVertical = height;
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        POSTNETLogicHandler handler = new POSTNETLogicHandler(this, new Canvas(canvas));
        POSTNETLogicImpl impl = new POSTNETLogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        impl.generateBarcodeLogic(handler, msg);
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        String modMsg = POSTNETLogicImpl.removeIgnoredCharacters(msg);
        double width = (double)(modMsg.length() * 5 + 2) * this.moduleWidth + (double)(modMsg.length() * 5 + 1) * this.intercharGapWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        double height = this.getHeight();
        if (this.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
            height -= this.getHumanReadableHeight();
        }
        return new BarcodeDimension(width, height, width + 2.0 * qz, height + 2.0 * qzv, this.quietZone, qzv);
    }

    @Override
    public double getBarHeight(int height) {
        if (height == 2) {
            return this.getBarHeight();
        }
        if (height == 1) {
            return this.shortBarHeight;
        }
        if (height == -1) {
            return this.getBarHeight();
        }
        throw new IllegalArgumentException("Only height 0 or 1 allowed");
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean value) {
        this.displayChecksum = value;
    }

    public BaselineAlignment getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(BaselineAlignment baselinePosition) {
        this.baselinePosition = baselinePosition;
    }
}

