/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;

public class Base64InputStream
extends InputStream {
    private static final int EOF = -1;
    private static final byte[] LOOKUP;
    private Reader source;
    private final char[] quadBuffer = new char[4];
    private final byte[] triple = new byte[3];
    private int tripleIndex = 4;
    private int tripleFilled;

    public Base64InputStream(Reader source) {
        if (source == null) {
            throw new NullPointerException("source must not be null");
        }
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.tripleIndex >= this.tripleFilled && !this.readNextTriple()) {
            return -1;
        }
        return this.triple[this.tripleIndex++];
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.source = null;
    }

    private boolean readNextTriple() throws IOException {
        int offset = 0;
        while (offset < 4) {
            int ch = this.source.read();
            if (ch < 0) {
                return false;
            }
            if (ch == 13 || ch == 10 || ch == 32) continue;
            this.quadBuffer[offset++] = (char)ch;
        }
        int quad = 0;
        this.tripleFilled = 3;
        for (int i = 0; i < 4; ++i) {
            int b = -1;
            char ch = this.quadBuffer[i];
            if ('=' == ch) {
                if (i < 2) {
                    throw new IOException("Padding character at invalid position");
                }
                this.tripleFilled = Math.min(i - 1, this.tripleFilled);
                break;
            }
            if (ch < '\u0080') {
                b = LOOKUP[ch];
            }
            if (b < 0) {
                throw new IOException("Illegal Base64 character encountered: " + ch);
            }
            quad |= b << (3 - i) * 6;
        }
        this.triple[0] = (byte)((quad & 0xFF0000) >> 16);
        this.triple[1] = (byte)((quad & 0xFF00) >> 8);
        this.triple[2] = (byte)(quad & 0xFF);
        this.tripleIndex = 0;
        return true;
    }

    private void checkOpen() throws IOException {
        if (this.source == null) {
            throw new IOException("Stream is already closed");
        }
    }

    static {
        int ch;
        LOOKUP = new byte[128];
        Arrays.fill(LOOKUP, (byte)-1);
        int idx = 0;
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            Base64InputStream.LOOKUP[ch] = (byte)idx++;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            Base64InputStream.LOOKUP[ch] = (byte)idx++;
        }
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            Base64InputStream.LOOKUP[ch] = (byte)idx++;
        }
        Base64InputStream.LOOKUP[45] = (byte)idx;
        Base64InputStream.LOOKUP[43] = (byte)idx++;
        Base64InputStream.LOOKUP[95] = (byte)idx;
        Base64InputStream.LOOKUP[47] = (byte)idx++;
    }
}

