/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian.component;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.extensions.arquillian.PrimeGraphene;
import org.primefaces.extensions.arquillian.component.base.AbstractInputComponent;

public abstract class SelectOneButton
extends AbstractInputComponent {
    @FindBy(css=".ui-button")
    private List<WebElement> options;
    @FindBy(css=".ui-button.ui-state-active")
    private WebElement activeOption;

    public List<String> getOptionLabels() {
        ArrayList<String> result = new ArrayList<String>();
        this.options.forEach(element -> result.add(element.getText()));
        return result;
    }

    public String getSelectedLabel() {
        return this.activeOption.getText();
    }

    public boolean isSelected(String label) {
        return this.getSelectedLabel().equalsIgnoreCase(label);
    }

    public void selectNext() {
        int activeIndex = this.options.indexOf(this.activeOption);
        int nextIndex = activeIndex + 1;
        if (nextIndex >= this.options.size()) {
            nextIndex = 0;
        }
        this.click(this.options.get(nextIndex));
    }

    public void select(String label) {
        if (!this.isSelected(label)) {
            for (WebElement element : this.options) {
                if (!element.getText().equalsIgnoreCase(label)) continue;
                this.click(element);
            }
        }
    }

    public void deselect(String label) {
        this.deselect(label, false);
    }

    public void deselect(String label, boolean ignoreDeselectable) {
        if (!ignoreDeselectable && !this.isUnselectable()) {
            return;
        }
        if (this.isSelected(label)) {
            for (WebElement element : this.options) {
                if (!element.getText().equalsIgnoreCase(label)) continue;
                this.click(element);
            }
        }
    }

    public boolean isUnselectable() {
        return "true".equals(PrimeGraphene.executeScript("return " + this.getWidgetByIdScript() + ".cfg.unselectable"));
    }

    protected void click(WebElement element) {
        if (PrimeGraphene.hasAjaxBehavior((WebElement)this.root, "change") || PrimeGraphene.hasAjaxBehavior((WebElement)this.root, "onchange")) {
            PrimeGraphene.guardAjaxSilently(element).click();
        } else {
            element.click();
        }
    }
}

