/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.qrcode;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.qrcode.QRCode;
import org.primefaces.extensions.renderkit.widget.WidgetRenderer;
import org.primefaces.renderkit.CoreRenderer;

public class QRCodeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        QRCode qrCode = (QRCode)component;
        this.encodeMarkup(context, qrCode);
        this.encodeScript(context, qrCode);
    }

    protected void encodeScript(FacesContext context, QRCode qrCode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = qrCode.getClientId(context);
        this.startScript(writer, clientId);
        WidgetRenderer.renderWidgetScript(context, clientId, writer, qrCode, false);
        this.endScript(writer);
    }

    private void encodeMarkup(FacesContext context, QRCode qrCode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = qrCode.getClientId(context);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

