/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeline;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.timeline.Timeline;
import org.primefaces.extensions.model.timeline.TimelineEvent;
import org.primefaces.extensions.model.timeline.TimelineModel;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.extensions.util.DateUtils;
import org.primefaces.extensions.util.FastStringWriter;
import org.primefaces.renderkit.CoreRenderer;

public class TimelineRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Timeline timeline = (Timeline)component;
        this.encodeMarkup(context, timeline);
        this.encodeScript(context, timeline);
    }

    protected void encodeMarkup(FacesContext context, Timeline timeline) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = timeline.getClientId(context);
        writer.startElement("div", (UIComponent)timeline);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (timeline.getStyle() != null) {
            writer.writeAttribute("style", (Object)timeline.getStyle(), "style");
        }
        if (timeline.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)timeline.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Timeline timeline) throws IOException {
        TimelineModel model = timeline.getValue();
        if (model == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = timeline.getClientId(context);
        TimeZone targetTZ = ComponentUtils.resolveTimeZone(timeline.getTimeZone());
        TimeZone browserTZ = ComponentUtils.resolveTimeZone(timeline.getBrowserTimeZone());
        FastStringWriter fsw = new FastStringWriter();
        FastStringWriter fswHtml = new FastStringWriter();
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFacesExt.cw('Timeline','" + timeline.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",data:[");
        List<TimelineEvent> events = model.getEvents();
        int size = events != null ? events.size() : 0;
        for (int i = 0; i < size; ++i) {
            writer.write(this.encodeEvent(context, fsw, fswHtml, timeline, browserTZ, targetTZ, events.get(i)));
            if (i + 1 >= size) continue;
            writer.write(",");
        }
        writer.write("],opts:{");
        writer.write("height:'" + timeline.getHeight() + "'");
        writer.write(",minHeight:" + timeline.getMinHeight());
        writer.write(",width:'" + timeline.getWidth() + "'");
        writer.write(",responsive:" + timeline.isResponsive());
        writer.write(",axisOnTop:" + timeline.isAxisOnTop());
        writer.write(",dragAreaWidth:" + timeline.getDragAreaWidth());
        writer.write(",editable:" + timeline.isEditable());
        writer.write(",selectable:" + timeline.isSelectable());
        writer.write(",unselectable:" + timeline.isUnselectable());
        writer.write(",zoomable:" + timeline.isZoomable());
        writer.write(",moveable:" + timeline.isMoveable());
        if (timeline.getStart() != null) {
            writer.write(",start:" + this.encodeDate(browserTZ, targetTZ, timeline.getStart()));
        }
        if (timeline.getEnd() != null) {
            writer.write(",end:" + this.encodeDate(browserTZ, targetTZ, timeline.getEnd()));
        }
        if (timeline.getMin() != null) {
            writer.write(",min:" + this.encodeDate(browserTZ, targetTZ, timeline.getMin()));
        }
        if (timeline.getMax() != null) {
            writer.write(",max:" + this.encodeDate(browserTZ, targetTZ, timeline.getMax()));
        }
        writer.write(",zoomMin:" + timeline.getZoomMin());
        writer.write(",zoomMax:" + timeline.getZoomMax());
        if (timeline.getPreloadFactor() < 0.0f) {
            writer.write(",preloadFactor:0");
        } else {
            writer.write(",preloadFactor:" + timeline.getPreloadFactor());
        }
        writer.write(",eventMargin:" + timeline.getEventMargin());
        writer.write(",eventMarginAxis:" + timeline.getEventMarginAxis());
        writer.write(",style:'" + timeline.getEventStyle() + "'");
        writer.write(",groupsChangeable:" + timeline.isGroupsChangeable());
        writer.write(",groupsOnRight:" + timeline.isGroupsOnRight());
        if (timeline.getGroupsWidth() != null) {
            writer.write(",groupsWidth:'" + timeline.getGroupsWidth() + "'");
        }
        writer.write(",snapEvents:" + timeline.isSnapEvents());
        writer.write(",stackEvents:" + timeline.isStackEvents());
        if (timeline.isShowCurrentTime()) {
            writer.write(",showCurrentTime:" + timeline.isShowCurrentTime());
            writer.write(",currentTime:" + this.encodeDate(browserTZ, targetTZ, Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime()));
        }
        writer.write(",showMajorLabels:" + timeline.isShowMajorLabels());
        writer.write(",showMinorLabels:" + timeline.isShowMinorLabels());
        writer.write(",showButtonNew:" + timeline.isShowButtonNew());
        writer.write(",showNavigation:" + timeline.isShowNavigation());
        if (timeline.getLocale() != null) {
            writer.write(",locale:'" + timeline.getLocale().toString() + "'");
        }
        if (timeline.getDropHoverStyleClass() != null) {
            writer.write(",hoverClass:'" + timeline.getDropHoverStyleClass() + "'");
        }
        if (timeline.getDropActiveStyleClass() != null) {
            writer.write(",activeClass:'" + timeline.getDropActiveStyleClass() + "'");
        }
        if (timeline.getDropAccept() != null) {
            writer.write(",accept:'" + timeline.getDropAccept() + "'");
        }
        if (timeline.getDropScope() != null) {
            writer.write(",scope:'" + timeline.getDropScope() + "'");
        }
        writer.write("}");
        this.encodeClientBehaviors(context, timeline);
        writer.write("},true);});");
        this.endScript(writer);
    }

    public String encodeEvent(FacesContext context, FastStringWriter fsw, FastStringWriter fswHtml, Timeline timeline, TimeZone browserTZ, TimeZone targetTZ, TimelineEvent event) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        fsw.write("{\"start\":" + this.encodeDate(browserTZ, targetTZ, event.getStartDate()));
        if (event.getEndDate() != null) {
            fsw.write(",\"end\":" + this.encodeDate(browserTZ, targetTZ, event.getEndDate()));
        } else {
            fsw.write(",\"end\":null");
        }
        if (event.isEditable() != null) {
            fsw.write(",\"editable\":" + event.isEditable());
        } else {
            fsw.write(",\"editable\":null");
        }
        if (event.getGroup() != null) {
            fsw.write(",\"group\":\"" + event.getGroup() + "\"");
        } else {
            fsw.write(",\"group\":null");
        }
        if (StringUtils.isNotBlank((CharSequence)event.getStyleClass())) {
            fsw.write(",\"className\":\"" + event.getStyleClass() + "\"");
        } else {
            fsw.write(",\"className\":null");
        }
        fsw.write(",\"content\":\"");
        if (timeline.getChildCount() > 0) {
            Object data = event.getData();
            if (StringUtils.isNotBlank((CharSequence)timeline.getVar()) && data != null) {
                context.getExternalContext().getRequestMap().put(timeline.getVar(), data);
            }
            ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fswHtml);
            context.setResponseWriter(clonedWriter);
            this.renderChildren(context, (UIComponent)timeline);
            context.setResponseWriter(writer);
            fsw.write(ComponentUtils.escapeHtmlTextInJson(fswHtml.toString()));
            fswHtml.reset();
        } else if (event.getData() != null) {
            fsw.write(event.getData().toString());
        }
        fsw.write("\"");
        fsw.write("}");
        String eventJson = fsw.toString();
        fsw.reset();
        return eventJson;
    }

    private String encodeDate(TimeZone browserTZ, TimeZone targetTZ, Date utcDate) {
        return "new Date(" + DateUtils.toLocalDate(browserTZ, targetTZ, utcDate) + ")";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

