/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import java.util.Locale;
import java.util.UUID;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LocaleUtils;

public class PrimeFacesResourceProcessor
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final String LIBRARY = "primefaces";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        String theme;
        FacesContext context = event.getFacesContext();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        String themeParamValue = configuration.getTheme();
        if (themeParamValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "saga";
        }
        if (theme != null && !"none".equals(theme)) {
            this.encodeCSS(context, "primefaces-" + theme, "theme.css");
        }
        if (configuration.isPrimeIconsEnabled()) {
            this.encodeCSS(context, LIBRARY, "primeicons/primeicons.css");
        }
        if (configuration.isFontAwesomeEnabled()) {
            this.encodeCSS(context, LIBRARY, "fa/font-awesome.css");
        }
        if (configuration.isClientSideValidationEnabled()) {
            this.encodeValidationResources(context, configuration.isBeanValidationEnabled());
        }
        if (configuration.isClientSideLocalizationEnabled()) {
            Locale locale = LocaleUtils.getCurrentLocale((FacesContext)context);
            this.encodeJS(context, "locales/locale-" + locale.getLanguage() + ".js");
        }
    }

    protected void encodeValidationResources(FacesContext context, boolean beanValidationEnabled) {
        this.encodeJS(context, "validation/validation.js");
        if (beanValidationEnabled) {
            this.encodeJS(context, "validation/validation.bv.js");
        }
    }

    private void encodeCSS(FacesContext context, String library, String name) {
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        if (resource == null) {
            throw new FacesException("Error loading CSS, cannot find \"" + name + "\" resource of \"" + library + "\" library");
        }
        UIOutput css = new UIOutput();
        css.setId("css-" + UUID.randomUUID().toString());
        css.setRendererType("javax.faces.resource.Stylesheet");
        css.getAttributes().put("library", library);
        css.getAttributes().put("name", name);
        context.getViewRoot().addComponentResource(context, (UIComponent)css, "head");
    }

    private void encodeJS(FacesContext context, String name) {
        Resource resource = context.getApplication().getResourceHandler().createResource(name, LIBRARY);
        if (resource == null) {
            throw new FacesException("Error loading JavaScript, cannot find \"" + name + "\" resource of \"" + LIBRARY + "\" library");
        }
        UIOutput js = new UIOutput();
        js.setId("js-" + UUID.randomUUID().toString());
        js.setRendererType("javax.faces.resource.Script");
        js.getAttributes().put("library", LIBRARY);
        js.getAttributes().put("name", name);
        context.getViewRoot().addComponentResource(context, (UIComponent)js, "head");
    }
}

