/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.scaffolding;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.extensions.component.scaffolding.Scaffolding;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ScaffoldingRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        Scaffolding scaffolding = (Scaffolding)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = scaffolding.getClientId()) && !scaffolding.isReady()) {
            ActionEvent event = new ActionEvent((UIComponent)scaffolding);
            scaffolding.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Scaffolding scaffolding = (Scaffolding)component;
        this.encodeMarkup(context, scaffolding);
        if (scaffolding.getValueExpression("loader") != null && !scaffolding.isReady()) {
            this.encodeScript(context, scaffolding);
        }
    }

    protected void encodeMarkup(FacesContext context, Scaffolding scaffolding) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = scaffolding.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-scaffolding ui-widget").add(scaffolding.getStyleClass()).build();
        writer.startElement("div", (UIComponent)scaffolding);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (scaffolding.getStyle() != null) {
            writer.writeAttribute("style", (Object)scaffolding.getStyle(), "style");
        }
        String facetName = scaffolding.isReady() ? "ready" : "loading";
        scaffolding.getFacet(facetName).encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Scaffolding scaffolding) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtScaffolding", (UIComponent)scaffolding).attr("async", scaffolding.isAsync(), true).attr("global", scaffolding.isGlobal(), true).attr("loadWhenVisible", scaffolding.isLoadWhenVisible(), false).finish();
    }
}

