/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.util.MessageFactory;

public class PhoneNumberUtilWrapper {
    private static final String MESSAGE_INVALID_VALUE_KEY = "primefaces.extensions.inputphone.INVALID";

    private PhoneNumberUtilWrapper() {
    }

    public static void validate(String number, String country) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse((CharSequence)number, country);
            if (!phoneNumberUtil.isValidNumber(phoneNumber)) {
                throw PhoneNumberUtilWrapper.getInvalidValueConverterException();
            }
        }
        catch (NumberParseException e) {
            throw PhoneNumberUtilWrapper.getInvalidValueConverterException();
        }
    }

    private static ConverterException getInvalidValueConverterException() {
        return new ConverterException(MessageFactory.getMessage(MESSAGE_INVALID_VALUE_KEY, FacesMessage.SEVERITY_ERROR, new Object[0]));
    }
}

