/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.monaco;

import java.io.Serializable;
import org.primefaces.shaded.owasp.encoder.Encode;

public class MonacoDiffEditorModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MonacoDiffEditorModel EMPTY = new MonacoDiffEditorModel();
    private final String originalValue;
    private final String modifiedValue;

    public MonacoDiffEditorModel() {
        this.originalValue = "";
        this.modifiedValue = "";
    }

    public MonacoDiffEditorModel(String originalValue, String modifiedValue) {
        this.originalValue = originalValue != null ? originalValue : "";
        this.modifiedValue = modifiedValue != null ? modifiedValue : "";
    }

    public MonacoDiffEditorModel withOriginal(String originalValue) {
        return new MonacoDiffEditorModel(originalValue, this.modifiedValue);
    }

    public MonacoDiffEditorModel withModified(String modifiedValue) {
        return new MonacoDiffEditorModel(this.originalValue, modifiedValue);
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getModifiedValue() {
        return this.modifiedValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modifiedValue == null ? 0 : this.modifiedValue.hashCode());
        result = 31 * result + (this.originalValue == null ? 0 : this.originalValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonacoDiffEditorModel other = (MonacoDiffEditorModel)obj;
        if (this.modifiedValue == null ? other.modifiedValue != null : !this.modifiedValue.equals(other.modifiedValue)) {
            return false;
        }
        return !(this.originalValue == null ? other.originalValue != null : !this.originalValue.equals(other.originalValue));
    }

    public boolean isEmpty() {
        return this.originalValue != null && !this.originalValue.isEmpty() && this.modifiedValue != null && !this.modifiedValue.isEmpty();
    }

    public String toString() {
        return "[\"" + Encode.forJava((String)this.originalValue) + "\",\"" + Encode.forJava((String)this.modifiedValue) + "\"]";
    }

    public static MonacoDiffEditorModel empty() {
        return EMPTY;
    }
}

