/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LocaleUtils;

public class PrimeFacesResourceProcessor
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PrimeFacesResourceProcessor.class.getName());
    private static final String LIBRARY = "primefaces";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        block8: {
            String theme;
            FacesContext context = event.getFacesContext();
            PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
            PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
            PrimeConfiguration configuration = applicationContext.getConfig();
            String themeParamValue = configuration.getTheme();
            if (themeParamValue != null) {
                ELContext elContext = context.getELContext();
                ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
                ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
                theme = (String)ve.getValue(elContext);
            } else {
                theme = "saga";
            }
            if (theme != null && !"none".equals(theme)) {
                this.encodeCSS(context, "primefaces-" + theme, "theme.css");
            }
            if (configuration.isPrimeIconsEnabled()) {
                this.encodeCSS(context, LIBRARY, "primeicons/primeicons.css");
            }
            if (configuration.isClientSideValidationEnabled()) {
                this.encodeValidationResources(context, configuration.isBeanValidationEnabled());
            }
            if (configuration.isClientSideLocalizationEnabled()) {
                try {
                    Locale locale = LocaleUtils.getCurrentLocale((FacesContext)context);
                    this.encodeJS(context, "locales/locale-" + locale.getLanguage() + ".js");
                }
                catch (FacesException e) {
                    if (!context.isProjectStage(ProjectStage.Development)) break block8;
                    LOGGER.log(Level.WARNING, "Failed to load client side locale.js. {0}", e.getMessage());
                }
            }
        }
    }

    protected void encodeValidationResources(FacesContext context, boolean beanValidationEnabled) {
        this.encodeJS(context, "validation/validation.js");
        if (beanValidationEnabled) {
            this.encodeJS(context, "validation/validation.bv.js");
        }
    }

    private void encodeCSS(FacesContext context, String library, String name) {
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        if (resource == null) {
            throw new FacesException("Error loading CSS, cannot find \"" + name + "\" resource of \"" + library + "\" library");
        }
        UIOutput css = new UIOutput();
        css.setId("css-" + UUID.randomUUID());
        css.setRendererType("javax.faces.resource.Stylesheet");
        css.getAttributes().put("library", library);
        css.getAttributes().put("name", name);
        String target = this.getTarget(context.getExternalContext(), "css");
        context.getViewRoot().addComponentResource(context, (UIComponent)css, target);
    }

    private void encodeJS(FacesContext context, String name) {
        Resource resource = context.getApplication().getResourceHandler().createResource(name, LIBRARY);
        if (resource == null) {
            throw new FacesException("Error loading JavaScript, cannot find \"" + name + "\" resource of \"" + LIBRARY + "\" library");
        }
        UIOutput js = new UIOutput();
        js.setId("js-" + UUID.randomUUID());
        js.setRendererType("javax.faces.resource.Script");
        js.getAttributes().put("library", LIBRARY);
        js.getAttributes().put("name", name);
        String target = this.getTarget(context.getExternalContext(), "js");
        context.getViewRoot().addComponentResource(context, (UIComponent)js, target);
    }

    private String getTarget(ExternalContext externalContext, String type) {
        String parameter = String.format("primefaces.%s.COMBINED_RESOURCE_HANDLER_DISABLED", type);
        String value = externalContext.getInitParameter(parameter);
        boolean disabled = Boolean.parseBoolean(value);
        return disabled ? "body" : "head";
    }
}

