/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.localized;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.primefaces.extensions.component.localized.Localized;
import org.primefaces.extensions.config.PrimeExtensionsEnvironment;
import org.primefaces.extensions.util.CommonMarkWrapper;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

public class LocalizedRenderer
extends CoreRenderer {
    public static final String WEB_FOLDER = "WEB-INF/pfe-localized";
    public static final String QUARKUS_FOLDER = "pfe-localized";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Localized localized = (Localized)component;
        this.encodeMarkup(context, localized);
    }

    protected void encodeMarkup(FacesContext context, Localized localized) throws IOException {
        if (LangUtils.isBlank((String)localized.getName())) {
            this.encodeFromFacet(context, localized);
        } else {
            this.encodeFromFile(context, localized);
        }
    }

    protected void encodeFromFacet(FacesContext context, Localized localized) throws IOException {
        Locale locale = localized.calculateLocale(context);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        this.resolveFacet(localized, language, country).encodeAll(context);
    }

    protected UIComponent resolveFacet(Localized localized, String language, String country) {
        UIComponent facet = localized.getFacet(language + "_" + country);
        if (ComponentUtils.shouldRenderFacet((UIComponent)facet)) {
            return facet;
        }
        facet = localized.getFacet(language);
        if (ComponentUtils.shouldRenderFacet((UIComponent)facet)) {
            return facet;
        }
        facet = localized.getFacet("default");
        if (ComponentUtils.shouldRenderFacet((UIComponent)facet)) {
            return facet;
        }
        throw new FacesException("No facet found for " + language + "_" + country + ", nor a 'default' facet");
    }

    protected void encodeFromFile(FacesContext context, Localized localized) throws IOException {
        Path filePath = this.resolvePath(context, localized);
        byte[] bytes = Files.readAllBytes(filePath);
        String value = new String(bytes);
        if (localized.isEvalEl()) {
            value = this.evaluateEl(context, value);
        }
        if (localized.isEscape()) {
            value = EscapeUtils.forHtml((String)value);
        }
        if (localized.isMarkdown()) {
            value = this.toHTML(context, value);
        }
        context.getResponseWriter().append((CharSequence)value);
    }

    protected Path resolvePath(FacesContext context, Localized localized) {
        String name;
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        String web = servletContext.getRealPath(WEB_FOLDER);
        String meta = servletContext.getRealPath(QUARKUS_FOLDER);
        Locale locale = localized.calculateLocale(context);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String folder = localized.getFolder();
        Path path = this.resolvePath(web, folder, name = localized.getName(), language, country);
        if (path == null) {
            path = this.resolvePath(web, null, name, language, country);
        }
        if (path == null) {
            path = this.resolvePath(meta, folder, name, language, country);
        }
        if (path == null) {
            path = this.resolvePath(meta, null, name, language, country);
        }
        if (path == null) {
            throw new IllegalStateException("Cannot find Localized file for: " + localized.getClientId(context));
        }
        return path;
    }

    protected Path resolvePath(String base, String folder, String name, String language, String country) {
        String baseFolder = LangUtils.isBlank((String)folder) ? base : base + "/" + folder;
        Path path = this.existingPath(baseFolder, name + "_" + language + "_" + country);
        if (path == null) {
            path = this.existingPath(baseFolder, name + "_" + language);
        }
        if (path == null) {
            path = this.existingPath(baseFolder, name);
        }
        return path;
    }

    protected Path existingPath(String first, String more) {
        Path existingPath;
        Path path = Paths.get(first, more);
        Path path2 = existingPath = path.toFile().exists() ? path : null;
        if (existingPath == null) {
            String resourcePath = first + "/" + more;
            try {
                URL url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
                if (url != null) {
                    existingPath = Paths.get(url.toURI());
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return existingPath;
    }

    protected String toHTML(FacesContext context, String value) {
        if (!PrimeExtensionsEnvironment.getCurrentInstance(context).isCommonmarkAvailable()) {
            throw new FacesException("CommonMark not available.");
        }
        return CommonMarkWrapper.toHTML(value);
    }

    protected String evaluateEl(FacesContext context, String value) {
        return (String)ExpressionFactory.newInstance().createValueExpression(context.getELContext(), value, String.class).getValue(context.getELContext());
    }
}

