/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timepicker;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.component.timepicker.TimePicker;
import org.primefaces.extensions.util.MessageFactory;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TimePickerRenderer
extends InputRenderer {
    private static final String BUTTON = "button";

    public void decode(FacesContext fc, UIComponent component) {
        TimePicker timepicker = (TimePicker)component;
        if (!this.shouldDecode((UIInput)timepicker)) {
            return;
        }
        String param = timepicker.getClientId(fc) + "_input";
        String submittedValue = (String)fc.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            timepicker.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(fc, (UIComponent)timepicker);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        TimePicker timepicker = (TimePicker)component;
        String value = this.getValueAsString(fc, timepicker);
        this.encodeMarkup(fc, timepicker, value);
        this.encodeScript(fc, timepicker, value);
    }

    public Object getConvertedValue(FacesContext fc, UIComponent component, Object submittedValue) {
        String value = (String)submittedValue;
        if (LangUtils.isBlank((String)value)) {
            return null;
        }
        TimePicker timepicker = (TimePicker)component;
        Converter converter = timepicker.getConverter();
        if (converter != null) {
            return converter.getAsObject(fc, (UIComponent)timepicker, value);
        }
        try {
            Class<?> type = this.resolveDateType(fc, timepicker);
            if (type == LocalTime.class) {
                DateTimeFormatter formatter = this.getDateTimeFormatter(timepicker);
                return LocalTime.parse(value, formatter);
            }
            SimpleDateFormat formatter = this.getSimpleDateFormat(timepicker);
            return formatter.parse(value);
        }
        catch (ParseException e) {
            throw new ConverterException(MessageFactory.getMessage(timepicker.calculateLocale(), "javax.faces.converter.DateTimeConverter.TIME", value, this.getDateTimeFormatter(timepicker).format(LocalDateTime.now()), MessageFactory.getLabel(fc, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    protected void encodeMarkup(FacesContext fc, TimePicker timepicker, String value) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = timepicker.getClientId(fc);
        String inputId = clientId + "_input";
        writer.startElement("span", (UIComponent)timepicker);
        writer.writeAttribute("id", (Object)clientId, null);
        String containerClass = "pe-timepicker ui-widget ui-corner-all";
        if (timepicker.isSpinner()) {
            containerClass = containerClass + " ui-spinner";
        }
        if (timepicker.isShowOnButton()) {
            containerClass = containerClass + " ui-inputgroup";
        }
        writer.writeAttribute("class", (Object)containerClass, null);
        if (timepicker.isInline()) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)(timepicker.isInline() ? "hidden" : "text"), null);
        if (timepicker.getSize() > 0) {
            writer.writeAttribute("size", (Object)timepicker.getSize(), null);
        }
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (timepicker.isReadonlyInput()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (LangUtils.isNotBlank((String)value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (!timepicker.isInline()) {
            String styleClass = this.getStyleClassBuilder(fc).add("ui-inputfield ui-state-default ui-corner-all").add(timepicker.getStyleClass()).add(timepicker.isSpinner(), "ui-spinner-input").add(timepicker.isShowOnButton(), "ui-inputtext").add(!timepicker.isValid(), "ui-state-error").build();
            writer.writeAttribute("class", (Object)styleClass, null);
            if (timepicker.getStyle() != null) {
                writer.writeAttribute("style", (Object)timepicker.getStyle(), null);
            }
        }
        this.renderAccessibilityAttributes(fc, (UIInput)timepicker);
        this.renderPassThruAttributes(fc, (UIComponent)timepicker, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(fc, (UIComponent)timepicker, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(fc, (EditableValueHolder)timepicker);
        writer.endElement("input");
        if (timepicker.isSpinner()) {
            boolean disabled = timepicker.isDisabled() || timepicker.isReadonly();
            this.encodeSpinnerButton(fc, "ui-spinner-button ui-spinner-up ui-corner-tr ui-button ui-widget ui-state-default", "ui-icon ui-icon-triangle-1-n", disabled);
            this.encodeSpinnerButton(fc, "ui-spinner-button ui-spinner-down ui-corner-br ui-button ui-widget ui-state-default", "ui-icon ui-icon-triangle-1-s", disabled);
        }
        if (timepicker.isShowOnButton()) {
            writer.startElement(BUTTON, null);
            writer.writeAttribute("class", (Object)"pe-timepicker-trigger ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only", null);
            writer.writeAttribute("type", (Object)BUTTON, null);
            writer.writeAttribute("role", (Object)BUTTON, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-clock", null);
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-text", null);
            writer.write("ui-button");
            writer.endElement("span");
            writer.endElement(BUTTON);
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext fc, TimePicker timepicker, String value) throws IOException {
        String clientId = timepicker.getClientId(fc);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.init("ExtTimePicker", (UIComponent)timepicker);
        wb.attr("timeSeparator", timepicker.getTimeSeparator());
        wb.attr("myPosition", timepicker.getDialogPosition());
        wb.attr("atPosition", timepicker.getInputPosition());
        wb.attr("showPeriod", Boolean.valueOf(timepicker.isShowPeriod()));
        wb.attr("showPeriodLabels", Boolean.valueOf(timepicker.isShowPeriod()));
        wb.attr("modeInline", Boolean.valueOf(timepicker.isInline()));
        wb.attr("modeSpinner", Boolean.valueOf(timepicker.isSpinner()));
        wb.nativeAttr("hours", "{starts:" + timepicker.getStartHours() + ",ends:" + timepicker.getEndHours() + "}");
        wb.nativeAttr("minutes", "{starts:" + timepicker.getStartMinutes() + ",ends:" + timepicker.getEndMinutes() + ",interval:" + timepicker.getIntervalMinutes() + "}");
        wb.attr("rows", (Number)timepicker.getRows());
        wb.attr("showHours", Boolean.valueOf(timepicker.isShowHours()));
        wb.attr("showMinutes", Boolean.valueOf(timepicker.isShowMinutes()));
        wb.attr("showCloseButton", Boolean.valueOf(timepicker.isShowCloseButton()));
        wb.attr("showNowButton", Boolean.valueOf(timepicker.isShowNowButton()));
        wb.attr("showDeselectButton", Boolean.valueOf(timepicker.isShowDeselectButton()));
        if (timepicker.getOnHourShow() != null) {
            wb.nativeAttr("onHourShow", timepicker.getOnHourShow());
        }
        if (timepicker.getOnMinuteShow() != null) {
            wb.nativeAttr("onMinuteShow", timepicker.getOnMinuteShow());
        }
        if (timepicker.isShowOnButton()) {
            wb.attr("showOn", timepicker.getShowOn());
            wb.selectorAttr(BUTTON, "#" + clientId + " .pe-timepicker-trigger");
        }
        wb.attr("locale", timepicker.calculateLocale().toString());
        wb.attr("disabled", Boolean.valueOf(timepicker.isDisabled() || timepicker.isReadonly()));
        if (LangUtils.isBlank((String)value)) {
            wb.attr("defaultTime", "");
        } else if (timepicker.isInline()) {
            wb.attr("defaultTime", value);
        }
        if (timepicker.getMinHour() != null || timepicker.getMinMinute() != null) {
            wb.nativeAttr("minTime", "{hour:" + timepicker.getMinHour() + ",minute:" + timepicker.getMinMinute() + "}");
        }
        if (timepicker.getMaxHour() != null || timepicker.getMaxMinute() != null) {
            wb.nativeAttr("maxTime", "{hour:" + timepicker.getMaxHour() + ",minute:" + timepicker.getMaxMinute() + "}");
        }
        this.encodeClientBehaviors(fc, (ClientBehaviorHolder)timepicker);
        wb.finish();
    }

    protected void encodeSpinnerButton(FacesContext fc, String styleClass, String iconClass, boolean disabled) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("a");
    }

    protected String getValueAsString(FacesContext fc, TimePicker timepicker) {
        Object submittedValue = timepicker.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = timepicker.getValue();
        if (value == null) {
            return null;
        }
        if (timepicker.getConverter() != null) {
            return timepicker.getConverter().getAsString(fc, (UIComponent)timepicker, value);
        }
        if (value instanceof LocalTime) {
            DateTimeFormatter formatter = this.getDateTimeFormatter(timepicker);
            return formatter.format((LocalTime)value);
        }
        SimpleDateFormat formatter = this.getSimpleDateFormat(timepicker);
        return formatter.format(value);
    }

    protected String getPattern(TimePicker timepicker) {
        return timepicker.isShowPeriod() ? timepicker.getTimePattern12() : timepicker.getTimePattern24();
    }

    protected DateTimeFormatter getDateTimeFormatter(TimePicker timepicker) {
        return DateTimeFormatter.ofPattern(this.getPattern(timepicker), timepicker.calculateLocale());
    }

    protected SimpleDateFormat getSimpleDateFormat(TimePicker timepicker) {
        return new SimpleDateFormat(this.getPattern(timepicker), timepicker.calculateLocale());
    }

    protected Class<?> resolveDateType(FacesContext context, TimePicker timePicker) {
        ValueExpression ve = timePicker.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class<LocalTime> type = ve.getType(context.getELContext());
        if (type == null) {
            type = LocalTime.class;
        }
        return type;
    }
}

