/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.waypoint;

import java.io.IOException;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.extensions.component.waypoint.Waypoint;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class WaypointRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        Waypoint waypoint = (Waypoint)component;
        this.encodeScript(fc, waypoint);
    }

    private void encodeScript(FacesContext fc, Waypoint waypoint) throws IOException {
        String context = SearchExpressionFacade.resolveClientIds((FacesContext)fc, (UIComponent)waypoint, (String)waypoint.getForContext());
        String target = SearchExpressionFacade.resolveClientIds((FacesContext)fc, (UIComponent)waypoint, (String)waypoint.getFor(), (Set)SearchExpressionUtils.SET_PARENT_FALLBACK);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.init("ExtWaypoint", (UIComponent)waypoint);
        wb.attr("target", target);
        wb.attr("continuous", Boolean.valueOf(waypoint.isContinuous()));
        wb.attr("enabled", Boolean.valueOf(waypoint.isEnabled()));
        wb.attr("horizontal", Boolean.valueOf(waypoint.isHorizontal()));
        wb.attr("triggerOnce", Boolean.valueOf(waypoint.isTriggerOnce()));
        if (context != null) {
            wb.attr("context", context);
        }
        if (waypoint.getOffset() != null) {
            wb.nativeAttr("offset", waypoint.getOffset());
        }
        this.encodeClientBehaviors(fc, waypoint);
        wb.finish();
    }
}

