
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Controls the behavior of editor guides.
 */
@SuppressWarnings("serial")
public class EditorGuidesOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorGuidesOptions(this);
    }

    private static class SerializedEditorGuidesOptions implements Serializable {
        private String json;

        public SerializedEditorGuidesOptions(EditorGuidesOptions editorGuidesOptions) {
            this.json = editorGuidesOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorGuidesOptions editorGuidesOptions = new EditorGuidesOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorGuidesOptions.put(key, value);
            }
            return editorGuidesOptions;
        }
    }

    /**
     * @return Enable rendering of bracket pair guides. Defaults to {@code false}.
     */
    public Boolean isBracketPairs() {
        return (Boolean) (has("bracketPairs") ? get("bracketPairs") : null);
    }

    /**
     * @param bracketPairs Enable rendering of bracket pair guides. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorGuidesOptions setBracketPairs(final Boolean bracketPairs) {
        put("bracketPairs", bracketPairs);
        return this;
    }

    /**
     * @return Enable rendering of vertical bracket pair guides. Defaults to {@code true}.
     */
    public Boolean isBracketPairsHorizontal() {
        return (Boolean) (has("bracketPairsHorizontal") ? get("bracketPairsHorizontal") : null);
    }

    /**
     * @param bracketPairsHorizontal Enable rendering of vertical bracket pair guides. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorGuidesOptions setBracketPairsHorizontal(final Boolean bracketPairsHorizontal) {
        put("bracketPairsHorizontal", bracketPairsHorizontal);
        return this;
    }

    /**
     * @return Enable highlighting of the active bracket pair. Defaults to {@code true}.
     */
    public Boolean isHighlightActiveBracketPair() {
        return (Boolean) (has("highlightActiveBracketPair") ? get("highlightActiveBracketPair") : null);
    }

    /**
     * @param highlightActiveBracketPair Enable highlighting of the active bracket pair. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorGuidesOptions setHighlightActiveBracketPair(final Boolean highlightActiveBracketPair) {
        put("highlightActiveBracketPair", highlightActiveBracketPair);
        return this;
    }

    /**
     * @return Enable highlighting of the active indent guide. Defaults to {@code true}.
     */
    public Boolean isHighlightActiveIndentation() {
        return (Boolean) (has("highlightActiveIndentation") ? get("highlightActiveIndentation") : null);
    }

    /**
     * @param highlightActiveIndentation Enable highlighting of the active indent guide. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorGuidesOptions setHighlightActiveIndentation(final Boolean highlightActiveIndentation) {
        put("highlightActiveIndentation", highlightActiveIndentation);
        return this;
    }

    /**
     * @return Enable rendering of indent guides. Defaults to {@code true}.
     */
    public Boolean isIndentation() {
        return (Boolean) (has("indentation") ? get("indentation") : null);
    }

    /**
     * @param indentation Enable rendering of indent guides. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorGuidesOptions setIndentation(final Boolean indentation) {
        put("indentation", indentation);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}