/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.suneditor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.component.api.RTLAware;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.extensions.component.suneditor.SunEditor;
import org.primefaces.extensions.util.HtmlSanitizer;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class SunEditorRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(SunEditorRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        SunEditor editor = (SunEditor)component;
        if (!this.shouldDecode((UIInput)editor)) {
            return;
        }
        String clientId = editor.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            String value = this.sanitizeHtml(context, editor, (String)params.get(clientId));
            editor.setSubmittedValue(value);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SunEditor editor = (SunEditor)component;
        this.checkSecurity(context, editor);
        this.encodeMarkup(context, editor);
        this.encodeScript(context, editor);
    }

    protected void encodeMarkup(FacesContext context, SunEditor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String style = editor.getStyle();
        String styleClass = this.createStyleClass((UIInput)editor, "ui-suneditor");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)editor);
        this.renderPassThruAttributes(context, (UIComponent)editor, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)editor, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)editor);
        String valueToRender = this.sanitizeHtml(context, editor, ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)editor));
        if (valueToRender != null) {
            if (editor.isSecure()) {
                valueToRender = this.fixFontFamily(valueToRender);
            }
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    protected String fixFontFamily(String valueToRender) {
        String regex = "font-family:\\s*&#39;([^&#]+)&#39;";
        Pattern pattern = Pattern.compile(regex);
        StringBuffer result = new StringBuffer(valueToRender);
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            String fontName = matcher.group(1);
            String correctedFont = Arrays.stream(fontName.split("\\s+")).map(SunEditorRenderer::capitalize).collect(Collectors.joining(" "));
            if (correctedFont.endsWith(" Ms")) {
                correctedFont = correctedFont.replace(" Ms", " MS");
            }
            if ("tahoma".equalsIgnoreCase(correctedFont)) {
                correctedFont = correctedFont.replace("Tahoma", "tahoma");
            }
            result.replace(matcher.start(), matcher.end(), "font-family: " + correctedFont);
            matcher = pattern.matcher(result);
        }
        return result.toString();
    }

    protected void encodeScript(FacesContext context, SunEditor editor) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtSunEditor", (UIComponent)editor).attr("width", editor.getWidth()).attr("height", editor.getHeight()).attr("mode", editor.getMode(), "classic").attr("rtl", ComponentUtils.isRTL((FacesContext)context, (RTLAware)editor), false).attr("locale", editor.calculateLocale().toString()).attr("readOnly", editor.isReadonly(), false).attr("disabled", editor.isDisabled(), false).attr("toolbar", editor.getToolbar()).nativeAttr("extender", editor.getExtender());
        this.encodeClientBehaviors(context, editor);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        SunEditor editor = (SunEditor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        return value;
    }

    private void checkSecurity(FacesContext context, SunEditor editor) {
        boolean sanitizerAvailable = PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment().isHtmlSanitizerAvailable();
        if (editor.isSecure() && !sanitizerAvailable) {
            throw new FacesException("SunEditor component is marked secure='true' but the HTML Sanitizer was not found on the classpath. Either add the HTML sanitizer to the classpath per the documentation or mark secure='false' if you would like to use the component without the sanitizer.");
        }
    }

    protected String sanitizeHtml(FacesContext context, SunEditor editor, String value) {
        String result = value;
        if (editor.isSecure() && PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment().isHtmlSanitizerAvailable()) {
            result = HtmlSanitizer.sanitizeHtml(value, editor.isAllowBlocks(), editor.isAllowFormatting(), editor.isAllowLinks(), editor.isAllowStyles(), editor.isAllowImages(), editor.isAllowTables(), editor.isAllowMedia());
        } else if (!(editor.isAllowBlocks() && editor.isAllowFormatting() && editor.isAllowLinks() && editor.isAllowStyles() && editor.isAllowImages() && editor.isAllowTables())) {
            LOGGER.warning("HTML sanitizer not available - skip sanitizing....");
        }
        return result;
    }

    public static String capitalize(String name) {
        if (LangUtils.isBlank((String)name)) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

