/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.primefaces.model.SortMeta;

public class BeanPropertyComparator
implements Comparator<Object> {
    private String var;
    private Locale locale;
    private Collator collator;
    private SortMeta sortMeta;

    public BeanPropertyComparator(String var, SortMeta sortMeta, Locale locale) {
        this.sortMeta = sortMeta;
        this.var = var;
        this.locale = locale;
        this.collator = Collator.getInstance(locale);
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueExpression sortBy = this.sortMeta.getSortBy();
        try {
            int result;
            context.getExternalContext().getRequestMap().put(this.var, obj1);
            Object value1 = sortBy.getValue(context.getELContext());
            context.getExternalContext().getRequestMap().put(this.var, obj2);
            Object value2 = sortBy.getValue(context.getELContext());
            if (this.sortMeta.getFunction() == null) {
                if (value1 == null && value2 == null) {
                    return 0;
                }
                if (value1 == null) {
                    result = this.sortMeta.getNullSortOrder();
                } else if (value2 == null) {
                    result = -1 * this.sortMeta.getNullSortOrder();
                } else if (value1 instanceof String && value2 instanceof String) {
                    if (this.sortMeta.isCaseSensitiveSort()) {
                        result = this.collator.compare(value1, value2);
                    } else {
                        String str1 = ((String)value1).toLowerCase(this.locale);
                        String str2 = ((String)value2).toLowerCase(this.locale);
                        result = this.collator.compare(str1, str2);
                    }
                } else {
                    result = ((Comparable)value1).compareTo(value2);
                }
            } else {
                result = (Integer)this.sortMeta.getFunction().invoke(context.getELContext(), new Object[]{value1, value2});
            }
            return this.sortMeta.getOrder().isAscending() ? result : -1 * result;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

