/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.monacoeditor;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.BehaviorEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.extensions.component.monacoeditor.DiffEditorPropertyKeys;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommon;
import org.primefaces.extensions.model.monaco.MonacoDiffEditorModel;
import org.primefaces.extensions.model.monacoeditor.DiffEditorOptions;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.MessageFactory;

public abstract class MonacoDiffEditorBase
extends MonacoEditorCommon<DiffEditorOptions> {
    static final String DEFAULT_EVENT = "change";
    static final Map<String, Class<? extends BehaviorEvent>> BASE_BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put((Object)"change", null).put((Object)"initialized", null).put((Object)"blur", null).put((Object)"focus", null).put((Object)"keydown", null).put((Object)"keyup", null).put((Object)"mousedown", null).put((Object)"mousemove", null).put((Object)"mouseup", null).put((Object)"paste", null).put((Object)"originalBlur", null).put((Object)"originalChange", null).put((Object)"originalFocus", null).put((Object)"originalKeydown", null).put((Object)"originalKeyup", null).put((Object)"originalMousedown", null).put((Object)"originalMousemove", null).put((Object)"originalMouseup", null).put((Object)"originalPaste", null).build();
    static final Collection<String> BASE_EVENT_NAMES = BASE_BEHAVIOR_EVENT_MAPPING.keySet();
    static final boolean DEFAULT_ORIGINAL_DISABLED = true;
    static final boolean DEFAULT_ORIGINAL_READONLY = false;
    static final boolean DEFAULT_ORIGINAL_REQUIRED = false;
    static final String DEFAULT_ORIGINAL_BASENAME = "";
    static final String DEFAULT_ORIGINAL_EXTENSION = "";
    static final String DEFAULT_ORIGINAL_DIRECTORY = "";
    static final String DEFAULT_ORIGINAL_SCHEME = "inmemory";
    static final String DEFAULT_ORIGINAL_LANGUAGE = null;

    protected MonacoDiffEditorBase(String rendererType) {
        super(rendererType, DiffEditorOptions.class);
    }

    public final boolean isOriginalDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalDisabled), (Object)true);
    }

    public final void setOriginalDisabled(boolean originalEditable) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalDisabled), (Object)originalEditable);
    }

    public final boolean isOriginalReadonly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalReadonly), (Object)false);
    }

    public final void setOriginalReadonly(boolean originalReadonly) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalReadonly), (Object)originalReadonly);
    }

    public final boolean isOriginalRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalRequired), (Object)false);
    }

    public final void setOriginalRequired(boolean originalRequired) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalRequired), (Object)originalRequired);
    }

    public final String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public String getLanguage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.language), null);
    }

    public void setLanguage(Object language) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.language), (Object)(language != null ? language.toString() : null));
    }

    public String getOriginalLanguage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalLanguage), null);
    }

    public void setOriginalLanguage(Object originalLanguage) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalLanguage), (Object)(originalLanguage != null ? originalLanguage.toString() : null));
    }

    public String getOnoriginalblur() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalblur), null);
    }

    public final void setOnoriginalblur(String onoriginalblur) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalblur), (Object)onoriginalblur);
    }

    public String getOnoriginalchange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalchange), null);
    }

    public final void setOnoriginalchange(String onoriginalchange) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalchange), (Object)onoriginalchange);
    }

    public String getOnoriginalfocus() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalfocus), null);
    }

    public final void setOnoriginalfocus(String onoriginalfocus) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalfocus), (Object)onoriginalfocus);
    }

    public String getOnoriginalkeyup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalkeyup), null);
    }

    public final void setOnoriginalkeyup(String onoriginalkeyup) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalkeyup), (Object)onoriginalkeyup);
    }

    public String getOnoriginalkeydown() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalkeydown), null);
    }

    public final void setOnoriginalkeydown(String onoriginalkeydown) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalkeydown), (Object)onoriginalkeydown);
    }

    public String getOnoriginalmouseup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmouseup), null);
    }

    public final void setOnoriginalmouseup(String onoriginalmouseup) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmouseup), (Object)onoriginalmouseup);
    }

    public String getOnoriginalmousedown() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmousedown), null);
    }

    public final void setOnoriginalmousedown(String onoriginalmousedown) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmousedown), (Object)onoriginalmousedown);
    }

    public String getOnoriginalmousemove() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmousemove), null);
    }

    public final void setOnoriginalmousemove(String onoriginalmousemove) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalmousemove), (Object)onoriginalmousemove);
    }

    public String getOnoriginalpaste() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.onoriginalpaste), null);
    }

    public final void setOnoriginalpaste(String onoriginalpaste) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.onoriginalpaste), (Object)onoriginalpaste);
    }

    public final String getOriginalDirectory() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalDirectory), (Object)"");
    }

    public final void setOriginalDirectory(String originalDirectory) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalDirectory), (Object)originalDirectory);
    }

    public final String getOriginalExtension() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalExtension), (Object)"");
    }

    public final void setOriginalExtension(String originalExtension) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalExtension), (Object)originalExtension);
    }

    public final String getOriginalBasename() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalBasename), (Object)"");
    }

    public final void setOriginalBasename(String basename) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalBasename), (Object)basename);
    }

    public final String getOriginalScheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)DiffEditorPropertyKeys.originalScheme), (Object)DEFAULT_ORIGINAL_SCHEME);
    }

    public final void setOriginalScheme(String originalScheme) {
        this.getStateHelper().put((Serializable)((Object)DiffEditorPropertyKeys.originalScheme), (Object)originalScheme);
    }

    protected void validateValue(FacesContext context, Object newValue) {
        Object label;
        FacesMessage message;
        String requiredMessageStr;
        MonacoDiffEditorModel model = (MonacoDiffEditorModel)newValue;
        if (this.isValid() && this.isRequired() && (model == null || MonacoDiffEditorBase.isEmpty((Object)model.getModifiedValue()))) {
            requiredMessageStr = this.getRequiredMessage();
            if (null != requiredMessageStr) {
                message = new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr);
            } else {
                label = MessageFactory.getLabel((FacesContext)context, (UIComponent)this);
                message = MessageFactory.getFacesMessage((String)"jakarta.faces.component.UIInput.REQUIRED", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (Object[])new Object[]{label.toString()});
            }
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && this.isOriginalRequired() && (model == null || MonacoDiffEditorBase.isEmpty((Object)model.getOriginalValue()))) {
            requiredMessageStr = this.getRequiredMessage();
            if (null != requiredMessageStr) {
                message = new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr);
            } else {
                label = MessageFactory.getLabel((FacesContext)context, (UIComponent)this);
                message = MessageFactory.getFacesMessage((String)"jakarta.faces.component.UIInput.REQUIRED", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (Object[])new Object[]{label.toString()});
            }
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        super.validateValue(context, newValue);
    }
}

