/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceWrapper;
import jakarta.faces.context.FacesContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.util.LangUtils;

public class ThemeAccentColorResource
extends ResourceWrapper {
    private static final Map<String, String> CACHE = new HashMap<String, String>();
    private static final Map<String, List<String>> ACCENT_COLORS = new HashMap<String, List<String>>();
    private final Resource wrapped;
    private final String charEncoding;

    public ThemeAccentColorResource(Resource wrapped) {
        this.wrapped = wrapped;
        String encoding = FacesContext.getCurrentInstance().getExternalContext().getRequestCharacterEncoding();
        if (LangUtils.isBlank((String)encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        this.charEncoding = encoding;
    }

    public InputStream getInputStream() throws IOException {
        String library = this.wrapped.getLibraryName();
        List<String> accentColors = ACCENT_COLORS.get(library);
        if (accentColors == null || accentColors.isEmpty()) {
            return this.wrapped.getInputStream();
        }
        if (CACHE.containsKey(library)) {
            return new ByteArrayInputStream(CACHE.get(library).getBytes(this.charEncoding));
        }
        String accentColor = "var(--" + library.replace("primefaces-", "") + "%d)";
        String css = this.getContent();
        for (int i = 0; i < accentColors.size(); ++i) {
            css = css.replace(accentColors.get(i), String.format(accentColor, i));
        }
        CACHE.put(library, css);
        return new ByteArrayInputStream(css.getBytes(this.charEncoding));
    }

    protected String getContent() throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        InputStream inputStream = this.wrapped.getInputStream();
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(this.charEncoding);
    }

    public Resource getWrapped() {
        return this.wrapped;
    }

    static {
        ACCENT_COLORS.put("primefaces-arya", Arrays.asList("#90caf9", "#6bb8f7", "#45a6f5", "#b1dafb", "rgba(255,255,255,.87)"));
        ACCENT_COLORS.put("primefaces-saga", Arrays.asList("#2196f3", "#0d89ec", "#0b7ad1", "#a6d5fa", "#495057"));
        ACCENT_COLORS.put("primefaces-vela", Arrays.asList("#90caf9", "#6bb8f7", "#45a6f5", "#b1dafb", "rgba(255,255,255,.87)"));
    }
}

