/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.masterdetail;

import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.AjaxBehaviorListener;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.primefaces.extensions.component.masterdetail.MasterDetailLevel;

public class SelectDetailLevelListener
implements AjaxBehaviorListener,
ActionListener,
StateHolder {
    private MethodExpression listener;

    public SelectDetailLevelListener() {
    }

    public SelectDetailLevelListener(MethodExpression listener) {
        this.listener = listener;
    }

    public void processAction(ActionEvent actionEvent) {
        this.process(actionEvent.getComponent());
    }

    public void processAjaxBehavior(AjaxBehaviorEvent event) {
        this.process(event.getComponent());
    }

    public void process(UIComponent source) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String clientId = source.getClientId(fc);
        MasterDetailLevel masterDetailLevel = this.findMasterDetailLevel(source);
        if (masterDetailLevel == null) {
            throw new FacesException("MasterDetailLevel was not found. SelectDetailLevel can be only used inside of MasterDetailLevel.");
        }
        HashMap<CallSite, Object> contextValues = (HashMap<CallSite, Object>)masterDetailLevel.getAttributes().get("mdContextValues");
        if (contextValues == null) {
            contextValues = new HashMap<CallSite, Object>();
        }
        Object contextValue = contextValues.get("contextValue_" + clientId);
        Object newContextValue = this.listener.invoke(fc.getELContext(), new Object[]{contextValue});
        if (newContextValue != null) {
            contextValues.put((CallSite)((Object)("contextValue_" + clientId)), newContextValue);
        } else {
            contextValues.remove("contextValue_" + clientId);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.listener = (MethodExpression)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.listener};
        return values;
    }

    public void setTransient(boolean value) {
    }

    private MasterDetailLevel findMasterDetailLevel(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MasterDetailLevel)) continue;
            return (MasterDetailLevel)parent;
        }
        return null;
    }
}

