/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.mongo;

import dev.morphia.Datastore;
import dev.morphia.query.CountOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.filters.RegexFilter;
import dev.morphia.query.internal.MorphiaCursor;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.Callbacks;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.PropertyDescriptorResolver;

public class MorphiaLazyDataModel<T>
extends LazyDataModel<T>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(MorphiaLazyDataModel.class.getName());
    protected Class<T> entityClass;
    protected Callbacks.SerializableSupplier<Datastore> datastore;
    protected String rowKeyField;
    protected Callbacks.SerializableFunction<T, Object> rowKeyProvider;
    private final Map<String, BiConsumer<Query<T>, FilterMeta>> overrides = new HashMap<String, BiConsumer<Query<T>, FilterMeta>>();
    private transient Consumer<Query<T>> prependConsumer;
    private transient BiConsumer<Query<T>, FilterMeta> globalFilterConsumer;
    private transient Callbacks.SerializableSupplier<FindOptions> findOptionsSupplier;
    private transient Callbacks.SerializableSupplier<CountOptions> countOptionsSupplier;

    public T getRowData(String rowKey) {
        List values = Objects.requireNonNullElseGet(this.getWrappedData(), Collections::emptyList);
        for (Object obj : values) {
            if (!Objects.equals(rowKey, this.getRowKey(obj))) continue;
            return (T)obj;
        }
        return null;
    }

    public String getRowKey(T object) {
        return String.valueOf(this.rowKeyProvider.apply(object));
    }

    public int count(Map<String, FilterMeta> map) {
        Query<T> q = this.buildQuery();
        CountOptions opts = this.getCountOptions();
        long count = this.applyFilters(q, map).count(opts);
        return (int)count;
    }

    public List<T> load(int first, int pageSize, Map<String, SortMeta> sort, Map<String, FilterMeta> filters) {
        Query<T> q = this.buildQuery();
        FindOptions opt = this.getFindOptions();
        sort.forEach((field, sortData) -> opt.sort(new Sort[]{sortData.getOrder() == SortOrder.DESCENDING ? Sort.descending((String)field) : Sort.ascending((String)field)}));
        this.applyFilters(q, filters);
        opt.skip(first).limit(pageSize);
        try (MorphiaCursor cursor = q.iterator(opt);){
            List list = cursor.toList();
            return list;
        }
    }

    protected FindOptions getFindOptions() {
        try {
            return this.findOptionsSupplier != null ? (FindOptions)this.findOptionsSupplier.get() : new FindOptions();
        }
        catch (Exception e) {
            return new FindOptions();
        }
    }

    protected CountOptions getCountOptions() {
        try {
            return this.countOptionsSupplier != null ? (CountOptions)this.countOptionsSupplier.get() : new CountOptions();
        }
        catch (Exception e) {
            return new CountOptions();
        }
    }

    public Query<T> applyFilters(Query<T> q, Map<String, FilterMeta> filters) {
        PrimeApplicationContext primeAppContext = PrimeApplicationContext.getCurrentInstance((FacesContext)FacesContext.getCurrentInstance());
        filters.forEach((field, metadata) -> {
            if (metadata.getFilterValue() != null) {
                BiConsumer<Query<Query>, FilterMeta> override = this.overrides.get(field);
                if (override != null) {
                    override.accept((Query<Query>)q, (FilterMeta)metadata);
                } else {
                    Object val = metadata.getFilterValue();
                    if (metadata.getMatchMode() != null) {
                        switch (metadata.getMatchMode()) {
                            case STARTS_WITH: {
                                RegexFilter regStartsWith = Filters.regex((String)field, (String)("^" + val)).caseInsensitive();
                                q.filter(new Filter[]{regStartsWith});
                                break;
                            }
                            case ENDS_WITH: {
                                RegexFilter regEndsWith = Filters.regex((String)field, (String)(val + "$")).caseInsensitive();
                                q.filter(new Filter[]{regEndsWith});
                                break;
                            }
                            case CONTAINS: {
                                q.filter(new Filter[]{Filters.regex((String)field, (String)("" + val)).caseInsensitive()});
                                break;
                            }
                            case EXACT: {
                                Object castedValueEx = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueEx != null) {
                                    q.filter(new Filter[]{Filters.eq((String)field, (Object)castedValueEx)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val)});
                                break;
                            }
                            case LESS_THAN: {
                                Object castedValueLt = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueLt != null) {
                                    q.filter(new Filter[]{Filters.lt((String)field, (Object)castedValueLt)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.lt((String)field, (Object)val)});
                                break;
                            }
                            case LESS_THAN_EQUALS: {
                                Object castedValueLte = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueLte != null) {
                                    q.filter(new Filter[]{Filters.lte((String)field, (Object)castedValueLte)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.lte((String)field, (Object)val)});
                                break;
                            }
                            case GREATER_THAN: {
                                Object castedValueGt = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueGt != null) {
                                    q.filter(new Filter[]{Filters.gt((String)field, (Object)castedValueGt)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.gt((String)field, (Object)val)});
                                break;
                            }
                            case GREATER_THAN_EQUALS: {
                                Object castedValueGte = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueGte != null) {
                                    q.filter(new Filter[]{Filters.gte((String)field, (Object)castedValueGte)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.gte((String)field, (Object)val)});
                                break;
                            }
                            case EQUALS: {
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val)});
                                break;
                            }
                            case IN: {
                                if (metadata.getFilterValue().getClass() != Object[].class) break;
                                Object[] parts = (Object[])metadata.getFilterValue();
                                q.filter(new Filter[]{Filters.in((String)field, Arrays.asList(parts))});
                                break;
                            }
                            case BETWEEN: {
                                List dates;
                                if (!(metadata.getFilterValue() instanceof List) || (dates = (List)metadata.getFilterValue()).size() <= 1) break;
                                q.filter(new Filter[]{Filters.gte((String)field, dates.get(0)), Filters.lte((String)field, dates.get(1))});
                                break;
                            }
                            case NOT_CONTAINS: {
                                q.filter(new Filter[]{Filters.regex((String)field, (String)("" + val)).caseInsensitive().not()});
                                break;
                            }
                            case NOT_EQUALS: {
                                Object castedValueNe = this.convertToDataType(primeAppContext, (String)field, val);
                                if (castedValueNe != null) {
                                    q.filter(new Filter[]{Filters.eq((String)field, (Object)castedValueNe).not()});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val).not()});
                                break;
                            }
                            case NOT_STARTS_WITH: {
                                RegexFilter regStartsWithNot = Filters.regex((String)field, (String)("^" + val)).caseInsensitive();
                                q.filter(new Filter[]{regStartsWithNot.not()});
                                break;
                            }
                            case NOT_IN: {
                                if (!(metadata.getFilterValue() instanceof Object[])) break;
                                Object[] parts = (Object[])metadata.getFilterValue();
                                q.filter(new Filter[]{Filters.nin((String)field, Arrays.asList(parts))});
                                break;
                            }
                            case NOT_ENDS_WITH: {
                                RegexFilter regEndsWithNot = Filters.regex((String)field, (String)(val + "$")).caseInsensitive();
                                q.filter(new Filter[]{regEndsWithNot.not()});
                                break;
                            }
                            case GLOBAL: {
                                if (this.globalFilterConsumer == null) break;
                                this.globalFilterConsumer.accept((Query<Query>)q, (FilterMeta)metadata);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("MatchMode " + metadata.getMatchMode() + " not supported");
                            }
                        }
                    }
                }
            }
        });
        return q;
    }

    @Deprecated
    public MorphiaLazyDataModel<T> prependQuery(Consumer<Query<T>> consumer) {
        this.prependConsumer = consumer;
        return this;
    }

    @Deprecated
    public MorphiaLazyDataModel<T> findOptions(Callbacks.SerializableSupplier<FindOptions> supplier) {
        this.findOptionsSupplier = supplier;
        return this;
    }

    @Deprecated
    public MorphiaLazyDataModel<T> countOptions(Callbacks.SerializableSupplier<CountOptions> supplier) {
        this.countOptionsSupplier = supplier;
        return this;
    }

    @Deprecated
    public MorphiaLazyDataModel<T> globalFilter(BiConsumer<Query<T>, FilterMeta> consumer) {
        this.globalFilterConsumer = consumer;
        return this;
    }

    @Deprecated
    public MorphiaLazyDataModel<T> overrideFieldQuery(String field, BiConsumer<Query<T>, FilterMeta> consumer) {
        this.overrides.put(field, consumer);
        return this;
    }

    private Object convertToDataType(PrimeApplicationContext primeAppContext, String field, Object value) {
        PropertyDescriptorResolver propResolver = primeAppContext.getPropertyDescriptorResolver();
        PropertyDescriptor propertyDescriptor = propResolver.get(this.entityClass, field);
        return ComponentUtils.convertToType((Object)value, propertyDescriptor.getPropertyType(), (Logger)LOGGER);
    }

    private Query<T> buildQuery() {
        Query q = ((Datastore)this.datastore.get()).find(this.entityClass).disableValidation();
        if (this.prependConsumer != null) {
            this.prependConsumer.accept(q);
        }
        return q;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final MorphiaLazyDataModel<T> model = new MorphiaLazyDataModel();

        public Builder<T> entityClass(Class<T> entityClass) {
            this.model.entityClass = entityClass;
            return this;
        }

        public Builder<T> datastore(Callbacks.SerializableSupplier<Datastore> datastore) {
            this.model.datastore = datastore;
            return this;
        }

        public Builder<T> rowKeyConverter(Converter<T> rowKeyConverter) {
            ((MorphiaLazyDataModel)this.model).rowKeyConverter = rowKeyConverter;
            return this;
        }

        public Builder<T> rowKeyProvider(Callbacks.SerializableFunction<T, Object> rowKeyProvider) {
            this.model.rowKeyProvider = rowKeyProvider;
            return this;
        }

        public Builder<T> rowKeyField(String rowKey) {
            this.model.rowKeyField = rowKey;
            return this;
        }

        public Builder<T> findOptions(Callbacks.SerializableSupplier<FindOptions> findOptionsSupplier) {
            this.model.findOptionsSupplier = findOptionsSupplier;
            return this;
        }

        public Builder<T> countOptions(Callbacks.SerializableSupplier<CountOptions> countOptionsSupplier) {
            this.model.countOptionsSupplier = countOptionsSupplier;
            return this;
        }

        public Builder<T> prependQuery(Consumer<Query<T>> consumer) {
            this.model.prependConsumer = consumer;
            return this;
        }

        public Builder<T> globalFilter(BiConsumer<Query<T>, FilterMeta> consumer) {
            this.model.globalFilterConsumer = consumer;
            return this;
        }

        public Builder<T> overrideFieldQuery(String field, BiConsumer<Query<T>, FilterMeta> consumer) {
            this.model.overrides.put(field, consumer);
            return this;
        }

        public MorphiaLazyDataModel<T> build() {
            boolean requiresRowKeyProvider;
            Objects.requireNonNull(this.model.entityClass, "entityClass not set");
            Objects.requireNonNull(this.model.datastore, "datastore not set");
            boolean bl = requiresRowKeyProvider = this.model.rowKeyProvider == null && (((MorphiaLazyDataModel)this.model).rowKeyConverter != null || this.model.rowKeyField != null);
            if (requiresRowKeyProvider) {
                if (((MorphiaLazyDataModel)this.model).rowKeyConverter != null) {
                    this.model.rowKeyProvider = (Callbacks.SerializableFunction & Serializable)x$0 -> this.model.getRowKeyFromConverter(x$0);
                } else {
                    Objects.requireNonNull(this.model.rowKeyField, "rowKeyField is mandatory if neither rowKeyProvider nor converter is provided");
                    PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance((FacesContext)FacesContext.getCurrentInstance()).getPropertyDescriptorResolver();
                    this.model.rowKeyProvider = (Callbacks.SerializableFunction & Serializable)obj -> propResolver.getValue(obj, this.model.rowKeyField);
                }
            }
            return this.model;
        }
    }
}

